/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Arrays;
import java.util.Objects;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.graphdb.Resource;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public class HeapTrackingIntArrayList
implements Resource {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingIntArrayList.class);
    private final MemoryTracker memoryTracker;
    private long trackedSize;
    private int size;
    private int[] elementData;

    public static HeapTrackingIntArrayList newIntArrayList(MemoryTracker memoryTracker) {
        return HeapTrackingIntArrayList.newIntArrayList(1, memoryTracker);
    }

    private HeapTrackingIntArrayList(HeapTrackingIntArrayList other) {
        int otherSize;
        this.size = otherSize = other.size;
        this.elementData = new int[otherSize];
        System.arraycopy(other.elementData, 0, this.elementData, 0, otherSize);
        this.memoryTracker = other.memoryTracker;
        this.trackedSize = HeapEstimator.shallowSizeOfObjectArray((int)otherSize);
        this.memoryTracker.allocateHeap(SHALLOW_SIZE + this.trackedSize);
    }

    public static HeapTrackingIntArrayList newIntArrayList(int initialSize, MemoryTracker memoryTracker) {
        Preconditions.requireNonNegative((int)initialSize);
        long trackedSize = HeapEstimator.sizeOfIntArray((int)initialSize);
        memoryTracker.allocateHeap(SHALLOW_SIZE + trackedSize);
        return new HeapTrackingIntArrayList(initialSize, memoryTracker, trackedSize);
    }

    private HeapTrackingIntArrayList(int initialSize, MemoryTracker memoryTracker, long trackedSize) {
        this.trackedSize = trackedSize;
        this.elementData = new int[initialSize];
        this.memoryTracker = memoryTracker;
    }

    public boolean add(int item) {
        this.add(item, this.elementData, this.size);
        return true;
    }

    public void add(int index, int element) {
        this.rangeCheckForAdd(index);
        int s = this.size;
        int[] elementData = this.elementData;
        if (s == elementData.length) {
            elementData = this.grow(this.size + 1);
        }
        System.arraycopy(elementData, index, elementData, index + 1, s - index);
        elementData[index] = element;
        this.size = s + 1;
    }

    public int get(int index) {
        Objects.checkIndex(index, this.size);
        return this.elementData[index];
    }

    public int set(int index, int element) {
        Objects.checkIndex(index, this.size);
        int oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    private void add(int e, int[] elementData, int s) {
        if (s == elementData.length) {
            elementData = this.grow(this.size + 1);
        }
        elementData[s] = e;
        this.size = s + 1;
    }

    public boolean contains(int e) {
        for (int i = 0; i < this.size; ++i) {
            if (this.elementData[i] != e) continue;
            return true;
        }
        return false;
    }

    public int indexOf(int e) {
        for (int i = 0; i < this.size; ++i) {
            if (this.elementData[i] != e) continue;
            return i;
        }
        return -1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean notEmpty() {
        return this.size != 0;
    }

    public void clear() {
        this.size = 0;
    }

    public void close() {
        if (this.elementData != null) {
            this.memoryTracker.releaseHeap(this.trackedSize + SHALLOW_SIZE);
            this.elementData = null;
        }
    }

    public boolean addAll(int ... values) {
        int numNew = values.length;
        if (numNew == 0) {
            return false;
        }
        int[] elementData = this.elementData;
        int s = this.size;
        if (numNew > elementData.length - s) {
            elementData = this.grow(s + numNew);
        }
        System.arraycopy(values, 0, elementData, s, numNew);
        this.size = s + numNew;
        return true;
    }

    public int[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    public HeapTrackingIntArrayList clone() {
        return new HeapTrackingIntArrayList(this);
    }

    public void truncate(int size) {
        if (size >= this.size) {
            return;
        }
        this.size = size;
    }

    private int[] grow(int minimumCapacity) {
        int newCapacity = HeapTrackingArrayList.newCapacity(minimumCapacity, this.elementData.length);
        long oldHeapUsage = this.trackedSize;
        this.trackedSize = HeapEstimator.sizeOfIntArray((int)newCapacity);
        this.memoryTracker.allocateHeap(this.trackedSize);
        int[] newItems = new int[newCapacity];
        System.arraycopy(this.elementData, 0, newItems, 0, Math.min(this.size, newCapacity));
        this.elementData = newItems;
        this.memoryTracker.releaseHeap(oldHeapUsage);
        return this.elementData;
    }

    private void rangeCheckForAdd(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }
}

