/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.AbstractResourceIterable;
import org.neo4j.internal.helpers.collection.CombiningIterable;
import org.neo4j.internal.helpers.collection.FilterIterable;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapIterable;

public final class Iterables {
    private Iterables() {
        throw new AssertionError((Object)"no instance");
    }

    public static <T> Iterable<T> empty() {
        return Collections.emptyList();
    }

    public static <T> ResourceIterable<T> emptyResourceIterable() {
        return EmptyResourceIterable.EMPTY_RESOURCE_ITERABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, C extends Collection<T>> C addAll(C collection, Iterable<? extends T> iterable) {
        try {
            Iterator<T> iterator = iterable.iterator();
            try {
                while (iterator.hasNext()) {
                    collection.add(iterator.next());
                }
            }
            finally {
                Iterators.tryCloseResource(iterator);
            }
        }
        finally {
            Iterables.tryCloseResource(iterable);
        }
        return collection;
    }

    public static <X> Iterable<X> filter(Predicate<? super X> specification, Iterable<X> i) {
        return new FilterIterable<X>(i, specification);
    }

    public static <X> List<X> reverse(List<X> iterable) {
        List<X> list = Iterables.asList(iterable);
        Collections.reverse(list);
        return list;
    }

    public static <FROM, TO> Iterable<TO> map(Function<? super FROM, ? extends TO> function, Iterable<FROM> from) {
        return new MapIterable<FROM, TO>(from, function);
    }

    @SafeVarargs
    public static <T, C extends T> Iterable<T> iterable(C ... items) {
        return Arrays.asList(items);
    }

    public static <T, C> Iterable<T> cast(Iterable<C> iterable) {
        return iterable;
    }

    @SafeVarargs
    public static <T> Iterable<T> concat(Iterable<? extends T> ... iterables) {
        return Iterables.concat(Arrays.asList(iterables));
    }

    public static <T> Iterable<T> concat(Iterable<? extends Iterable<T>> iterables) {
        return new CombiningIterable(iterables);
    }

    public static <T, C extends T> Iterable<T> append(final C item, Iterable<T> iterable) {
        return () -> {
            final Iterator iterator = iterable.iterator();
            return new Iterator<T>(){
                T last;
                {
                    this.last = item;
                }

                @Override
                public boolean hasNext() {
                    return iterator.hasNext() || this.last != null;
                }

                @Override
                public T next() {
                    if (iterator.hasNext()) {
                        return iterator.next();
                    }
                    try {
                        Object t = this.last;
                        return t;
                    }
                    finally {
                        this.last = null;
                    }
                }

                @Override
                public void remove() {
                }
            };
        };
    }

    public static Object[] asArray(Iterable<Object> iterable) {
        return Iterables.asArray(Object.class, iterable);
    }

    public static <T> T[] asArray(Class<T> componentType, Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        List<Object> list = Iterables.asList(iterable);
        return list.toArray((Object[])Array.newInstance(componentType, list.size()));
    }

    public static <T> ResourceIterable<T> asResourceIterable(final Iterable<T> iterable) {
        if (iterable instanceof ResourceIterable) {
            return (ResourceIterable)iterable;
        }
        return new AbstractResourceIterable<T>(){

            @Override
            protected ResourceIterator<T> newIterator() {
                return Iterators.asResourceIterator(iterable.iterator());
            }

            @Override
            protected void onClosed() {
                Iterables.tryCloseResource(iterable);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Iterable<?> values, String separator) {
        Iterator<?> it = values.iterator();
        try {
            StringBuilder sb = new StringBuilder();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(separator);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            Iterators.tryCloseResource(it);
            Iterables.tryCloseResource(values);
        }
    }

    public static <T> T firstOrNull(Iterable<T> iterable) {
        try {
            T t = Iterators.firstOrNull(iterable.iterator());
            return t;
        }
        finally {
            Iterables.tryCloseResource(iterable);
        }
    }

    public static <T> T first(Iterable<T> iterable) {
        try {
            T t = Iterators.first(iterable.iterator());
            return t;
        }
        finally {
            Iterables.tryCloseResource(iterable);
        }
    }

    public static <T> T last(Iterable<T> iterable) {
        try {
            T t = Iterators.last(iterable.iterator());
            return t;
        }
        finally {
            Iterables.tryCloseResource(iterable);
        }
    }

    public static <T> T singleOrNull(Iterable<T> iterable) {
        try {
            T t = Iterators.singleOrNull(iterable.iterator());
            return t;
        }
        finally {
            Iterables.tryCloseResource(iterable);
        }
    }

    public static <T> T single(Iterable<T> iterable) {
        try {
            T t = Iterators.single(iterable.iterator());
            return t;
        }
        finally {
            Iterables.tryCloseResource(iterable);
        }
    }

    public static <T> T single(Iterable<T> iterable, T itemIfNone) {
        try {
            T t = Iterators.single(iterable.iterator(), itemIfNone);
            return t;
        }
        finally {
            Iterables.tryCloseResource(iterable);
        }
    }

    public static <T> long count(Iterable<T> iterable) {
        return Iterables.count(iterable, Predicates.alwaysTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> long count(Iterable<T> iterable, Predicate<T> filter) {
        try {
            long l = Iterators.count(iterable.iterator(), filter);
            return l;
        }
        finally {
            Iterables.tryCloseResource(iterable);
        }
    }

    public static <T> Collection<T> asCollection(Iterable<T> iterable) {
        return Iterables.addAll(new ArrayList(), iterable);
    }

    public static <T> List<T> asList(Iterable<T> iterable) {
        return Iterables.addAll(new ArrayList(), iterable);
    }

    public static <T> Set<T> asSet(Iterable<T> iterable) {
        return Iterables.addAll(new HashSet(), iterable);
    }

    public static <T> Set<T> asUniqueSet(Iterable<T> iterable) {
        try {
            Set set = Iterators.addToCollectionUnique(iterable, new HashSet());
            return set;
        }
        finally {
            Iterables.tryCloseResource(iterable);
        }
    }

    public static Iterable<Long> asIterable(long ... array) {
        return () -> Iterators.asIterator(array);
    }

    public static Iterable<Integer> asIterable(int ... array) {
        return () -> Iterators.asIterator(array);
    }

    @SafeVarargs
    public static <T> Iterable<T> asIterable(T ... array) {
        return () -> Iterators.iterator(array);
    }

    public static <T> ResourceIterable<T> resourceIterable(final Iterable<T> iterable) {
        return new AbstractResourceIterable<T>(){

            @Override
            protected ResourceIterator<T> newIterator() {
                Iterator iterator = iterable.iterator();
                Resource resource = iterator instanceof Resource ? (Resource)iterator : Resource.EMPTY;
                return Iterators.resourceIterator(iterator, resource);
            }

            @Override
            protected void onClosed() {
                Iterables.tryCloseResource(iterable);
            }
        };
    }

    public static <T> Iterable<T> option(T item) {
        if (item == null) {
            return Collections.emptyList();
        }
        return () -> Iterators.iterator(item);
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return Iterables.stream(iterable, 0);
    }

    public static <T> Stream<T> stream(Iterable<T> iterable, int characteristics) {
        Objects.requireNonNull(iterable);
        return (Stream)Iterators.stream(iterable.iterator(), characteristics).onClose(() -> Iterables.tryCloseResource(iterable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> void forEach(Iterable<V> iterable, Consumer<V> consumer) {
        try {
            for (V item : iterable) {
                consumer.accept(item);
            }
        }
        finally {
            Iterables.tryCloseResource(iterable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> void safeForAll(Iterable<T> subjects, ThrowingConsumer<T, E> consumer) throws E {
        try {
            Throwable exception = null;
            for (T instance : subjects) {
                try {
                    consumer.accept(instance);
                }
                catch (Throwable t) {
                    exception = Exceptions.chain(exception, (Throwable)t);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        finally {
            Iterables.tryCloseResource(subjects);
        }
    }

    public static void tryCloseResource(Iterable<?> iterable) {
        if (iterable instanceof Resource) {
            Resource closeable = (Resource)iterable;
            closeable.close();
        }
    }

    private static class EmptyResourceIterable<T>
    implements ResourceIterable<T> {
        private static final ResourceIterable<Object> EMPTY_RESOURCE_ITERABLE = new EmptyResourceIterable<Object>();

        private EmptyResourceIterable() {
        }

        public ResourceIterator<T> iterator() {
            return Iterators.emptyResourceIterator();
        }

        public void close() {
        }
    }
}

