/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Arrays;
import java.util.Objects;
import org.neo4j.collection.PrimitiveLongResourceCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.graphdb.Resource;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public class HeapTrackingLongArrayList
implements Resource {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingLongArrayList.class);
    private final MemoryTracker memoryTracker;
    private long trackedSize;
    private int size;
    private long[] elementData;

    public static HeapTrackingLongArrayList newLongArrayList(MemoryTracker memoryTracker) {
        return HeapTrackingLongArrayList.newLongArrayList(1, memoryTracker);
    }

    public static HeapTrackingLongArrayList newLongArrayList(int initialSize, MemoryTracker memoryTracker) {
        Preconditions.requireNonNegative((int)initialSize);
        long trackedSize = HeapEstimator.sizeOfLongArray((int)initialSize);
        memoryTracker.allocateHeap(SHALLOW_SIZE + trackedSize);
        return new HeapTrackingLongArrayList(initialSize, memoryTracker, trackedSize);
    }

    private HeapTrackingLongArrayList(int initialSize, MemoryTracker memoryTracker, long trackedSize) {
        this.trackedSize = trackedSize;
        this.elementData = new long[initialSize];
        this.memoryTracker = memoryTracker;
    }

    public boolean add(long item) {
        this.add(item, this.elementData, this.size);
        return true;
    }

    public void add(int index, long element) {
        this.rangeCheckForAdd(index);
        int s = this.size;
        long[] elementData = this.elementData;
        if (s == elementData.length) {
            elementData = this.grow(this.size + 1);
        }
        System.arraycopy(elementData, index, elementData, index + 1, s - index);
        elementData[index] = element;
        this.size = s + 1;
    }

    public long get(int index) {
        Objects.checkIndex(index, this.size);
        return this.elementData[index];
    }

    public long set(int index, long element) {
        Objects.checkIndex(index, this.size);
        long oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    private void add(long e, long[] elementData, int s) {
        if (s == elementData.length) {
            elementData = this.grow(this.size + 1);
        }
        elementData[s] = e;
        this.size = s + 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean notEmpty() {
        return this.size != 0;
    }

    public void clear() {
        Arrays.fill(this.elementData, 0, this.size, 0L);
        this.size = 0;
    }

    public void close() {
        if (this.elementData != null) {
            this.memoryTracker.releaseHeap(this.trackedSize + SHALLOW_SIZE);
            this.elementData = null;
        }
    }

    public PrimitiveLongResourceIterator iterator() {
        return new PrimitiveLongResourceCollections.AbstractPrimitiveLongBaseResourceIterator(this){
            private int index;
            {
                this.index = -1;
            }

            @Override
            protected boolean fetchNext() {
                ++this.index;
                return this.index < HeapTrackingLongArrayList.this.size && this.next(HeapTrackingLongArrayList.this.elementData[this.index]);
            }
        };
    }

    public long removeLast() {
        long previous = this.elementData[this.size - 1];
        --this.size;
        this.elementData[this.size] = 0L;
        return previous;
    }

    public boolean addAll(long ... longs) {
        return this.addAll0(longs, longs.length);
    }

    private boolean addAll0(long[] longs, int numNew) {
        if (numNew == 0) {
            return false;
        }
        long[] elementData = this.elementData;
        int s = this.size;
        if (numNew > elementData.length - s) {
            elementData = this.grow(s + numNew);
        }
        System.arraycopy(longs, 0, elementData, s, numNew);
        this.size = s + numNew;
        return true;
    }

    public void addAll(HeapTrackingLongArrayList other) {
        this.addAll0(other.elementData, other.size);
    }

    private long[] grow(int minimumCapacity) {
        int newCapacity = HeapTrackingArrayList.newCapacity(minimumCapacity, this.elementData.length);
        long oldHeapUsage = this.trackedSize;
        this.trackedSize = HeapEstimator.sizeOfLongArray((int)newCapacity);
        this.memoryTracker.allocateHeap(this.trackedSize);
        long[] newItems = new long[newCapacity];
        System.arraycopy(this.elementData, 0, newItems, 0, Math.min(this.size, newCapacity));
        this.elementData = newItems;
        this.memoryTracker.releaseHeap(oldHeapUsage);
        return this.elementData;
    }

    private void rangeCheckForAdd(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }
}

