/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.neo4j.collection.trackable.HeapTrackingConcurrentHashCollection;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public final class HeapTrackingConcurrentBag<E>
extends HeapTrackingConcurrentHashCollection<E>
implements AutoCloseable {
    private static final long SHALLOW_SIZE_THIS = HeapEstimator.shallowSizeOfInstance(HeapTrackingConcurrentBag.class);

    public static <E> HeapTrackingConcurrentBag<E> newBag(MemoryTracker memoryTracker) {
        return HeapTrackingConcurrentBag.newBag(memoryTracker, 16);
    }

    public static <E> HeapTrackingConcurrentBag<E> newBag(MemoryTracker memoryTracker, int size) {
        memoryTracker.allocateHeap(SHALLOW_SIZE_THIS);
        return new HeapTrackingConcurrentBag<E>(memoryTracker, size);
    }

    public static long staticSizeOfWrapperObject() {
        return SHALLOW_SIZE_WRAPPER;
    }

    private HeapTrackingConcurrentBag(MemoryTracker memoryTracker, int initialCapacity) {
        super(memoryTracker, initialCapacity);
    }

    @Override
    int hash(Object key) {
        return this.hash(System.identityHashCode(key));
    }

    public void add(E value) {
        int length;
        AtomicReferenceArray currentArray = this.table;
        int hash = this.hash(value);
        int index = HeapTrackingConcurrentBag.indexFor(hash, length = currentArray.length());
        Object o = currentArray.get(index);
        if (o == null) {
            HeapTrackingConcurrentHashCollection.Node<E> newNode = new HeapTrackingConcurrentHashCollection.Node<E>(value, null);
            this.addToSize(1);
            if (currentArray.compareAndSet(index, null, newNode)) {
                return;
            }
            this.addToSize(-1);
        }
        this.slowAdd(value, hash, currentArray);
    }

    private void slowAdd(E value, int hash, AtomicReferenceArray<Object> currentArray) {
        int length;
        Object o;
        while (true) {
            int index;
            if ((o = currentArray.get(index = HeapTrackingConcurrentBag.indexFor(hash, length = currentArray.length()))) == RESIZED || o == RESIZING) {
                currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, index);
                continue;
            }
            HeapTrackingConcurrentHashCollection.Node<E> newNode = new HeapTrackingConcurrentHashCollection.Node<E>(value, (HeapTrackingConcurrentHashCollection.Node)o);
            if (currentArray.compareAndSet(index, o, newNode)) break;
        }
        this.incrementSizeAndPossiblyResize(currentArray, length, o);
    }
}

