/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.neo4j.com.ResourcePool;
import org.neo4j.helpers.Triplet;
import org.neo4j.kernel.impl.util.StringLogger;

public class LoggingResourcePoolMonitor
extends ResourcePool.Monitor.Adapter<Triplet<Channel, ChannelBuffer, ByteBuffer>> {
    private final StringLogger msgLog;
    private int lastCurrentPeakSize = -1;
    private int lastTargetSize = -1;

    public LoggingResourcePoolMonitor(StringLogger msgLog) {
        this.msgLog = msgLog;
    }

    @Override
    public void updatedCurrentPeakSize(int currentPeakSize) {
        if (this.lastCurrentPeakSize != currentPeakSize) {
            this.msgLog.debug("ResourcePool updated currentPeakSize to " + currentPeakSize);
            this.lastCurrentPeakSize = currentPeakSize;
        }
    }

    @Override
    public void created(Triplet<Channel, ChannelBuffer, ByteBuffer> resource) {
        this.msgLog.debug("ResourcePool create resource " + resource);
    }

    @Override
    public void updatedTargetSize(int targetSize) {
        if (this.lastTargetSize != targetSize) {
            this.msgLog.debug("ResourcePool updated targetSize to " + targetSize);
            this.lastTargetSize = targetSize;
        }
    }
}

