/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.ServerFailureException;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TxExtractor;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Triplet;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;

public class ServerUtil {
    public static final Predicate<Long> ALL = new Predicate<Long>(){

        public boolean accept(Long item) {
            return true;
        }
    };
    public static final TxHandler NO_ACTION = new TxHandler(){

        @Override
        public void accept(Triplet<String, Long, TxExtractor> tx, XaDataSource dataSource) {
        }

        @Override
        public void done() {
        }
    };

    private static File getBaseDir(String storeDir) {
        File file = new File(storeDir);
        try {
            return file.getCanonicalFile().getAbsoluteFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    private static String relativePath(File baseDir, File storeFile) throws IOException {
        String prefix = baseDir.getCanonicalPath();
        String path = storeFile.getCanonicalPath();
        if (!path.startsWith(prefix)) {
            throw new FileNotFoundException();
        }
        if ((path = path.substring(prefix.length())).startsWith(File.separator)) {
            return path.substring(1);
        }
        return path;
    }

    public static RequestContext.Tx[] rotateLogs(XaDataSourceManager dsManager, KernelPanicEventGenerator kernelPanicEventGenerator, StringLogger logger) {
        Collection sources = dsManager.getAllRegisteredDataSources();
        RequestContext.Tx[] appliedTransactions = new RequestContext.Tx[sources.size()];
        int i = 0;
        for (XaDataSource ds : sources) {
            try {
                appliedTransactions[i++] = RequestContext.lastAppliedTx(ds.getName(), ds.getXaContainer().getResourceManager().rotateLogicalLog());
            }
            catch (IOException e) {
                logger.logMessage("Unable to rotate log for " + ds, (Throwable)e);
                kernelPanicEventGenerator.generateEvent(ErrorState.TX_MANAGER_NOT_OK, new Throwable());
                throw new ServerFailureException(e);
            }
        }
        return appliedTransactions;
    }

    public static RequestContext rotateLogsAndStreamStoreFiles(String storeDir, XaDataSourceManager dsManager, KernelPanicEventGenerator kernelPanicEventGenerator, StringLogger logger, boolean includeLogicalLogs, StoreWriter writer, FileSystemAbstraction fs) {
        File baseDir = ServerUtil.getBaseDir(storeDir);
        RequestContext context = RequestContext.anonymous(ServerUtil.rotateLogs(dsManager, kernelPanicEventGenerator, logger));
        ByteBuffer temporaryBuffer = ByteBuffer.allocateDirect(0x100000);
        for (XaDataSource ds : dsManager.getAllRegisteredDataSources()) {
            ServerUtil.copyStoreFiles(writer, fs, baseDir, temporaryBuffer, ds);
            if (!includeLogicalLogs) continue;
            ServerUtil.copyLogicalLogs(writer, fs, baseDir, temporaryBuffer, ds);
        }
        return context;
    }

    private static void copyLogicalLogs(StoreWriter writer, FileSystemAbstraction fs, File baseDir, ByteBuffer temporaryBuffer, XaDataSource ds) {
        block18: {
            try {
                ResourceIterator files = ds.listLogicalLogs();
                Throwable throwable = null;
                block13: while (true) {
                    try {
                        while (files.hasNext()) {
                            File storeFile = (File)files.next();
                            try {
                                ServerUtil.copyFile(writer, fs, baseDir, temporaryBuffer, storeFile);
                                continue block13;
                            }
                            catch (FileNotFoundException ignored) {
                            }
                        }
                        break block18;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (files != null) {
                        if (throwable != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            files.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new ServerFailureException(e);
            }
        }
    }

    private static void copyStoreFiles(StoreWriter writer, FileSystemAbstraction fs, File baseDir, ByteBuffer temporaryBuffer, XaDataSource ds) {
        try (ResourceIterator files = ds.listStoreFiles();){
            while (files.hasNext()) {
                File storeFile = (File)files.next();
                ServerUtil.copyFile(writer, fs, baseDir, temporaryBuffer, storeFile);
            }
        }
        catch (IOException e) {
            throw new ServerFailureException(e);
        }
    }

    private static void copyFile(StoreWriter writer, FileSystemAbstraction fs, File baseDir, ByteBuffer temporaryBuffer, File storeFile) throws IOException {
        try (FileChannel fileChannel = fs.open(storeFile, "r");){
            writer.write(ServerUtil.relativePath(baseDir, storeFile), fileChannel, temporaryBuffer, storeFile.length() > 0L);
        }
    }

    private static LogExtractor getTransactionStreamForDatasource(final XaDataSource dataSource, final long startTxId, final long endTxId, List<Triplet<String, Long, TxExtractor>> stream, Predicate<Long> filter) {
        LogExtractor logExtractor = null;
        try {
            long serverLastTx = dataSource.getLastCommittedTxId();
            if (serverLastTx < endTxId) {
                throw new RuntimeException("Was requested to extract transaction ids " + startTxId + " to " + endTxId + " from data source " + dataSource.getName() + " but largest transaction id in server is " + serverLastTx);
            }
            try {
                logExtractor = dataSource.getLogExtractor(startTxId, endTxId);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            final LogExtractor finalLogExtractor = logExtractor;
            for (long txId = startTxId; txId <= endTxId; ++txId) {
                if (!filter.accept((Object)txId)) continue;
                final long finalTxId = txId;
                TxExtractor extractor = new TxExtractor(){

                    @Override
                    public ReadableByteChannel extract() {
                        InMemoryLogBuffer buffer = new InMemoryLogBuffer();
                        this.extract((LogBuffer)buffer);
                        return buffer;
                    }

                    @Override
                    public void extract(LogBuffer buffer) {
                        try {
                            long extractedTxId = finalLogExtractor.extractNext(buffer);
                            if (extractedTxId == -1L) {
                                throw new RuntimeException("Transaction " + finalTxId + " is missing and can't be extracted from " + dataSource.getName() + ". Was about to extract " + startTxId + " to " + endTxId);
                            }
                            if (extractedTxId != finalTxId) {
                                throw new RuntimeException("Expected txId " + finalTxId + ", but was " + extractedTxId);
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                stream.add((Triplet<String, Long, TxExtractor>)Triplet.of((Object)dataSource.getName(), (Object)txId, (Object)extractor));
            }
            return logExtractor;
        }
        catch (Throwable t) {
            if (logExtractor != null) {
                logExtractor.close();
            }
            throw Exceptions.launderedException((Throwable)t);
        }
    }

    public static <T> Response<T> packResponse(StoreId storeId, XaDataSourceManager dsManager, RequestContext context, T response, Predicate<Long> filter) {
        ArrayList<Triplet<String, Long, TxExtractor>> stream = new ArrayList<Triplet<String, Long, TxExtractor>>();
        HashSet<String> resourceNames = new HashSet<String>();
        ArrayList<LogExtractor> logExtractors = new ArrayList<LogExtractor>();
        try {
            for (RequestContext.Tx txEntry : context.lastAppliedTransactions()) {
                String resourceName = txEntry.getDataSourceName();
                XaDataSource dataSource = dsManager.getXaDataSource(resourceName);
                if (dataSource == null) {
                    throw new RuntimeException("No data source '" + resourceName + "' found");
                }
                resourceNames.add(resourceName);
                long serverLastTx = dataSource.getLastCommittedTxId();
                if (txEntry.getTxId() >= serverLastTx) continue;
                LogExtractor logExtractor = ServerUtil.getTransactionStreamForDatasource(dataSource, txEntry.getTxId() + 1L, serverLastTx, stream, filter);
                logExtractors.add(logExtractor);
            }
            return new Response<T>(response, storeId, ServerUtil.createTransactionStream(resourceNames, stream, logExtractors), ResourceReleaser.NO_OP);
        }
        catch (Throwable t) {
            for (LogExtractor extractor : logExtractors) {
                extractor.close();
            }
            throw Exceptions.launderedException((Throwable)t);
        }
    }

    public static Response<Void> getTransactions(GraphDatabaseAPI graphDb, String dataSourceName, long startTx, long endTx) {
        ArrayList<Triplet<String, Long, TxExtractor>> stream = new ArrayList<Triplet<String, Long, TxExtractor>>();
        XaDataSourceManager dsManager = ServerUtil.dsManager(graphDb);
        XaDataSource dataSource = dsManager.getXaDataSource(dataSourceName);
        if (dataSource == null) {
            throw new RuntimeException("No data source '" + dataSourceName + "' found");
        }
        List<LogExtractor> extractors = startTx < endTx ? Collections.singletonList(ServerUtil.getTransactionStreamForDatasource(dataSource, startTx, endTx, stream, ALL)) : Collections.emptyList();
        return new Response<Object>(null, graphDb.storeId(), ServerUtil.createTransactionStream(Collections.singletonList(dataSourceName), stream, extractors), ResourceReleaser.NO_OP);
    }

    private static XaDataSourceManager dsManager(GraphDatabaseAPI graphDb) {
        return (XaDataSourceManager)graphDb.getDependencyResolver().resolveDependency(XaDataSourceManager.class);
    }

    private static TransactionStream createTransactionStream(Collection<String> resourceNames, final List<Triplet<String, Long, TxExtractor>> stream, final List<LogExtractor> logExtractors) {
        return new TransactionStream(resourceNames.toArray(new String[resourceNames.size()])){
            private final Iterator<Triplet<String, Long, TxExtractor>> iterator;
            {
                super(x0);
                this.iterator = stream.iterator();
            }

            protected Triplet<String, Long, TxExtractor> fetchNextOrNull() {
                return this.iterator.hasNext() ? this.iterator.next() : null;
            }

            @Override
            public void close() {
                for (LogExtractor extractor : logExtractors) {
                    extractor.close();
                }
            }
        };
    }

    public static <T> Response<T> packResponseWithoutTransactionStream(StoreId storeId, T response) {
        return new Response<T>(response, storeId, TransactionStream.EMPTY, ResourceReleaser.NO_OP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void applyReceivedTransactions(Response<T> response, XaDataSourceManager xaDsm, TxHandler txHandler) throws IOException {
        try {
            for (Triplet tx : IteratorUtil.asIterable((Iterator)((Object)response.transactions()))) {
                String resourceName = (String)tx.first();
                XaDataSource dataSource = xaDsm.getXaDataSource(resourceName);
                txHandler.accept((Triplet<String, Long, TxExtractor>)tx, dataSource);
                try (ReadableByteChannel txStream = ((TxExtractor)tx.third()).extract();){
                    dataSource.applyCommittedTransaction(((Long)tx.second()).longValue(), txStream);
                }
            }
            txHandler.done();
        }
        finally {
            response.close();
        }
    }

    public static TxHandler txHandlerForFullCopy() {
        return new TxHandler(){
            private final Set<String> visitedDataSources = new HashSet<String>();

            @Override
            public void accept(Triplet<String, Long, TxExtractor> tx, XaDataSource dataSource) {
                if (this.visitedDataSources.add((String)tx.first())) {
                    dataSource.setLastCommittedTxId((Long)tx.second() - 1L);
                }
            }

            @Override
            public void done() {
            }
        };
    }

    public static URI getUriForScheme(final String scheme, Iterable<URI> uris) {
        return (URI)Iterables.first((Iterable)Iterables.filter((Predicate)new Predicate<URI>(){

            public boolean accept(URI item) {
                return item.getScheme().equals(scheme);
            }
        }, uris));
    }

    public static String getHostString(InetSocketAddress socketAddress) {
        if (socketAddress.isUnresolved()) {
            return socketAddress.getHostName();
        }
        return socketAddress.getAddress().getHostAddress();
    }

    public static interface TxHandler {
        public void accept(Triplet<String, Long, TxExtractor> var1, XaDataSource var2);

        public void done();
    }
}

