/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.neo4j.com.Connection;
import org.neo4j.com.PortIterator;
import org.neo4j.helpers.HostnamePort;

public class PortRangeSocketBinder {
    private ServerBootstrap bootstrap;
    private static final String ALL_INTERFACES_ADDRESS = "0.0.0.0";

    public PortRangeSocketBinder(ServerBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public Connection bindToFirstAvailablePortInRange(HostnamePort serverAddress) throws ChannelException {
        int[] ports = serverAddress.getPorts();
        String host = serverAddress.getHost();
        ChannelException lastException = null;
        PortIterator portIterator = new PortIterator(ports);
        while (portIterator.hasNext()) {
            Integer port = portIterator.next();
            InetSocketAddress socketAddress = host == null || host.equals(ALL_INTERFACES_ADDRESS) ? new InetSocketAddress(port) : new InetSocketAddress(host, (int)port);
            try {
                Channel channel = this.bootstrap.bind((SocketAddress)socketAddress);
                return new Connection(socketAddress, channel);
            }
            catch (ChannelException e) {
                if (lastException != null) {
                    e.addSuppressed((Throwable)lastException);
                }
                lastException = e;
            }
        }
        throw lastException;
    }
}

