/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.com.storecopy.StoreWriter;

public class ToFileStoreWriter
implements StoreWriter {
    private final File basePath;
    private final StoreCopyClient.Monitor monitor;

    public ToFileStoreWriter(File graphDbStoreDir, StoreCopyClient.Monitor monitor) {
        this.basePath = graphDbStoreDir;
        this.monitor = monitor;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public long write(String path, ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData) throws IOException {
        try {
            temporaryBuffer.clear();
            File file = new File(this.basePath, path);
            file.getParentFile().mkdirs();
            this.monitor.startReceivingStoreFile(file);
            try {
                try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");){
                    long totalWritten = 0L;
                    if (hasData) {
                        FileChannel channel = randomAccessFile.getChannel();
                        while (data.read(temporaryBuffer) >= 0) {
                            temporaryBuffer.flip();
                            totalWritten += (long)temporaryBuffer.limit();
                            channel.write(temporaryBuffer);
                            temporaryBuffer.clear();
                        }
                    }
                    long l = totalWritten;
                    return l;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.monitor.finishReceivingStoreFile(file);
            }
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    @Override
    public void close() {
    }
}

