/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import org.neo4j.com.Response;
import org.neo4j.com.storecopy.BatchingResponseHandler;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.TransactionObligationFulfiller;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class TransactionCommittingResponseUnpacker
extends LifecycleAdapter
implements ResponseUnpacker {
    public static final int DEFAULT_BATCH_SIZE = 100;
    static final String msg = "Kernel panic detected: pulled transactions cannot be applied to a non-healthy database. In order to resolve this issue a manual restart of this instance is required.";
    private final Dependencies dependencies;
    private final int maxBatchSize;
    private TransactionCommitProcess commitProcess;
    private TransactionObligationFulfiller obligationFulfiller;
    private Log log;
    private volatile boolean stopped;

    public TransactionCommittingResponseUnpacker(DependencyResolver dependencies, int maxBatchSize) {
        this(new ResolvableDependencies(dependencies), maxBatchSize);
    }

    public TransactionCommittingResponseUnpacker(Dependencies dependencies, int maxBatchSize) {
        this.dependencies = dependencies;
        this.maxBatchSize = maxBatchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpackResponse(Response<?> response, ResponseUnpacker.TxHandler txHandler) throws Exception {
        if (this.stopped) {
            throw new IllegalStateException("Component is currently stopped");
        }
        BatchingResponseHandler responseHandler = new BatchingResponseHandler(this.maxBatchSize, batch -> this.commitProcess.commit(batch, CommitEvent.NULL, TransactionApplicationMode.EXTERNAL), this.obligationFulfiller, txHandler, this.log);
        try {
            response.accept(responseHandler);
        }
        finally {
            responseHandler.applyQueuedTransactions();
        }
    }

    public void start() {
        this.commitProcess = this.dependencies.commitProcess();
        this.obligationFulfiller = this.dependencies.obligationFulfiller();
        this.log = this.dependencies.logService().getInternalLog(BatchingResponseHandler.class);
        this.stopped = false;
    }

    public void stop() {
        this.stopped = true;
    }

    private static class ResolvableDependencies
    implements Dependencies {
        private final DependencyResolver resolver;

        public ResolvableDependencies(DependencyResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public TransactionCommitProcess commitProcess() {
            return new TransactionRepresentationCommitProcess((TransactionAppender)this.resolver.resolveDependency(TransactionAppender.class), (StorageEngine)this.resolver.resolveDependency(StorageEngine.class));
        }

        @Override
        public TransactionObligationFulfiller obligationFulfiller() {
            try {
                return (TransactionObligationFulfiller)this.resolver.resolveDependency(TransactionObligationFulfiller.class);
            }
            catch (UnsatisfiedDependencyException e) {
                return toTxId -> {
                    throw new UnsupportedOperationException("Should not be called");
                };
            }
        }

        @Override
        public LogService logService() {
            return (LogService)this.resolver.resolveDependency(LogService.class);
        }
    }

    public static interface Dependencies {
        public TransactionCommitProcess commitProcess();

        public TransactionObligationFulfiller obligationFulfiller();

        public LogService logService();
    }
}

