/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

public final class RequestContext {
    private final int machineId;
    private final long lastAppliedTransaction;
    private final int eventIdentifier;
    private final int hashCode;
    private final long epoch;
    private final long checksum;
    public static final RequestContext EMPTY = new RequestContext(-1L, -1, -1, -1L, -1L);

    public RequestContext(long epoch, int machineId, int eventIdentifier, long lastAppliedTransaction, long checksum) {
        this.epoch = epoch;
        this.machineId = machineId;
        this.eventIdentifier = eventIdentifier;
        this.lastAppliedTransaction = lastAppliedTransaction;
        this.checksum = checksum;
        long hash = epoch;
        hash = 31L * hash ^ (long)eventIdentifier;
        hash = 31L * hash ^ (long)machineId;
        this.hashCode = (int)(hash >>> 32 ^ hash);
    }

    public int machineId() {
        return this.machineId;
    }

    public long lastAppliedTransaction() {
        return this.lastAppliedTransaction;
    }

    public int getEventIdentifier() {
        return this.eventIdentifier;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public String toString() {
        return "RequestContext[machineId=" + this.machineId + ", lastAppliedTransaction=" + this.lastAppliedTransaction + ", eventIdentifier=" + this.eventIdentifier + ", hashCode=" + this.hashCode + ", epoch=" + this.epoch + ", checksum=" + this.checksum + ']';
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RequestContext)) {
            return false;
        }
        RequestContext o = (RequestContext)obj;
        return o.eventIdentifier == this.eventIdentifier && o.machineId == this.machineId && o.epoch == this.epoch;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static RequestContext anonymous(long lastAppliedTransaction) {
        return new RequestContext(RequestContext.EMPTY.epoch, RequestContext.EMPTY.machineId, RequestContext.EMPTY.eventIdentifier, lastAppliedTransaction, RequestContext.EMPTY.checksum);
    }
}

