/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.neo4j.io.pagecache.FileHandle;
import org.neo4j.io.pagecache.PageCache;

@FunctionalInterface
public interface FileMoveAction {
    public void move(File var1, CopyOption ... var2) throws IOException;

    public static FileMoveAction copyViaPageCache(File file, PageCache pageCache) {
        return (toDir, copyOptions) -> {
            Optional handle = pageCache.streamFilesRecursive(file).findAny();
            if (handle.isPresent()) {
                ((FileHandle)handle.get()).rename(new File(toDir, file.getName()), copyOptions);
            }
        };
    }

    public static FileMoveAction copyViaFileSystem(File file, File basePath) {
        Path base = basePath.toPath();
        return (toDir, copyOptions) -> {
            Path originalPath = file.toPath();
            Path relativePath = base.relativize(originalPath);
            Path resolvedPath = toDir.toPath().resolve(relativePath);
            Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
            Files.copy(originalPath, resolvedPath, copyOptions);
        };
    }
}

