/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Optional;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ServerFailureException;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.storageengine.api.StoreFileMetadata;

public class StoreCopyServer {
    private final NeoStoreDataSource dataSource;
    private final CheckPointer checkPointer;
    private final FileSystemAbstraction fileSystem;
    private final File storeDirectory;
    private final Monitor monitor;
    private final PageCache pageCache;

    public StoreCopyServer(NeoStoreDataSource dataSource, CheckPointer checkPointer, FileSystemAbstraction fileSystem, File storeDirectory, Monitor monitor, PageCache pageCache) {
        this.dataSource = dataSource;
        this.checkPointer = checkPointer;
        this.fileSystem = fileSystem;
        this.storeDirectory = FileUtils.getMostCanonicalFile((File)storeDirectory);
        this.monitor = monitor;
        this.pageCache = pageCache;
    }

    public Monitor monitor() {
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestContext flushStoresAndStreamStoreFiles(String triggerName, StoreWriter writer, boolean includeLogs) {
        try {
            String storeCopyIdentifier = Thread.currentThread().getName();
            this.monitor.startTryCheckPoint(storeCopyIdentifier);
            long lastAppliedTransaction = this.checkPointer.tryCheckPoint((TriggerInfo)new SimpleTriggerInfo(triggerName));
            this.monitor.finishTryCheckPoint(storeCopyIdentifier);
            ByteBuffer temporaryBuffer = ByteBuffer.allocateDirect((int)ByteUnit.mebiBytes((long)1L));
            this.monitor.startStreamingStoreFiles(storeCopyIdentifier);
            try (ResourceIterator files = this.dataSource.listStoreFiles(includeLogs);){
                while (files.hasNext()) {
                    StoreChannel fileChannel;
                    block41: {
                        StoreFileMetadata meta = (StoreFileMetadata)files.next();
                        File file = meta.file();
                        int recordSize = meta.recordSize();
                        Optional optionalPagedFile = this.pageCache.getExistingMapping(file);
                        if (optionalPagedFile.isPresent()) {
                            PagedFile pagedFile = (PagedFile)optionalPagedFile.get();
                            long fileSize = pagedFile.fileSize();
                            try {
                                ReadableByteChannel fileChannel2 = pagedFile.openReadableByteChannel();
                                Throwable throwable = null;
                                try {
                                    this.doWrite(writer, temporaryBuffer, file, recordSize, fileChannel2, fileSize, storeCopyIdentifier);
                                    continue;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (fileChannel2 == null) continue;
                                    if (throwable != null) {
                                        try {
                                            fileChannel2.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    fileChannel2.close();
                                    continue;
                                }
                            }
                            finally {
                                pagedFile.close();
                                continue;
                            }
                        }
                        fileChannel = this.fileSystem.open(file, "r");
                        Throwable throwable = null;
                        try {
                            long fileSize = this.fileSystem.getFileSize(file);
                            this.doWrite(writer, temporaryBuffer, file, recordSize, (ReadableByteChannel)fileChannel, fileSize, storeCopyIdentifier);
                            if (fileChannel == null) continue;
                            if (throwable == null) break block41;
                        }
                        catch (Throwable throwable4) {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (fileChannel == null) throw throwable5;
                                if (throwable != null) {
                                    try {
                                        fileChannel.close();
                                        throw throwable5;
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                        throw throwable5;
                                    }
                                }
                                fileChannel.close();
                                throw throwable5;
                            }
                        }
                        try {
                            fileChannel.close();
                            continue;
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                            continue;
                        }
                    }
                    fileChannel.close();
                }
                return RequestContext.anonymous(lastAppliedTransaction);
            }
            finally {
                this.monitor.finishStreamingStoreFiles(storeCopyIdentifier);
            }
        }
        catch (IOException e) {
            throw new ServerFailureException(e);
        }
    }

    private void doWrite(StoreWriter writer, ByteBuffer temporaryBuffer, File file, int recordSize, ReadableByteChannel fileChannel, long fileSize, String storeCopyIdentifier) throws IOException {
        this.monitor.startStreamingStoreFile(file, storeCopyIdentifier);
        writer.write(FileUtils.relativePath((File)this.storeDirectory, (File)file), fileChannel, temporaryBuffer, fileSize > 0L, recordSize);
        this.monitor.finishStreamingStoreFile(file, storeCopyIdentifier);
    }

    public static interface Monitor {
        public void startTryCheckPoint(String var1);

        public void finishTryCheckPoint(String var1);

        public void startStreamingStoreFile(File var1, String var2);

        public void finishStreamingStoreFile(File var1, String var2);

        public void startStreamingStoreFiles(String var1);

        public void finishStreamingStoreFiles(String var1);

        public void startStreamingTransactions(long var1, String var3);

        public void finishStreamingTransactions(long var1, String var3);

        public static class Adapter
        implements Monitor {
            @Override
            public void startTryCheckPoint(String storeCopyIdentifier) {
            }

            @Override
            public void finishTryCheckPoint(String storeCopyIdentifier) {
            }

            @Override
            public void startStreamingStoreFile(File file, String storeCopyIdentifier) {
            }

            @Override
            public void finishStreamingStoreFile(File file, String storeCopyIdentifier) {
            }

            @Override
            public void startStreamingStoreFiles(String storeCopyIdentifier) {
            }

            @Override
            public void finishStreamingStoreFiles(String storeCopyIdentifier) {
            }

            @Override
            public void startStreamingTransactions(long startTxId, String storeCopyIdentifier) {
            }

            @Override
            public void finishStreamingTransactions(long endTxId, String storeCopyIdentifier) {
            }
        }
    }
}

