/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;

public class BlockLogBuffer
implements Closeable {
    static final byte FULL_BLOCK_AND_MORE = 0;
    static final int MAX_SIZE = 256;
    static final int DATA_SIZE = 255;
    private final ChannelBuffer target;
    private final ByteCounterMonitor monitor;
    private final byte[] byteArray = new byte[264];
    private final ByteBuffer byteBuffer = ByteBuffer.wrap(this.byteArray);

    public BlockLogBuffer(ChannelBuffer target, ByteCounterMonitor monitor) {
        this.target = target;
        this.monitor = monitor;
        this.clearInternalBuffer();
    }

    private void clearInternalBuffer() {
        this.byteBuffer.clear();
        this.byteBuffer.put((byte)0);
    }

    private BlockLogBuffer checkFlush() throws IOException {
        if (this.byteBuffer.position() > 256) {
            this.flush(256);
        }
        return this;
    }

    private void flush(int howManyBytesToWrite) throws IOException {
        this.target.writeBytes(this.byteArray, 0, howManyBytesToWrite);
        this.monitor.bytesWritten((long)howManyBytesToWrite);
        int pos = this.byteBuffer.position();
        this.clearInternalBuffer();
        this.byteBuffer.put(this.byteArray, howManyBytesToWrite, pos - howManyBytesToWrite);
    }

    public BlockLogBuffer put(byte b) throws IOException {
        this.byteBuffer.put(b);
        return this.checkFlush();
    }

    public BlockLogBuffer putShort(short s) throws IOException {
        this.byteBuffer.putShort(s);
        return this.checkFlush();
    }

    public BlockLogBuffer putInt(int i) throws IOException {
        this.byteBuffer.putInt(i);
        return this.checkFlush();
    }

    public BlockLogBuffer putLong(long l) throws IOException {
        this.byteBuffer.putLong(l);
        return this.checkFlush();
    }

    public BlockLogBuffer putFloat(float f) throws IOException {
        this.byteBuffer.putFloat(f);
        return this.checkFlush();
    }

    public BlockLogBuffer putDouble(double d) throws IOException {
        this.byteBuffer.putDouble(d);
        return this.checkFlush();
    }

    public BlockLogBuffer put(byte[] bytes, int length) throws IOException {
        int toWrite;
        for (int pos = 0; pos < length; pos += toWrite) {
            toWrite = Math.min(this.byteBuffer.remaining(), length - pos);
            this.byteBuffer.put(bytes, pos, toWrite);
            this.checkFlush();
        }
        return this;
    }

    @Override
    public void close() {
        assert (this.byteBuffer.position() > 1) : "buffer should contain more than the header";
        assert (this.byteBuffer.position() <= 256) : "buffer should not be over full";
        long howManyBytesToWrite = this.byteBuffer.position();
        this.byteBuffer.put(0, (byte)(this.byteBuffer.position() - 1));
        this.byteBuffer.flip();
        this.target.writeBytes(this.byteBuffer);
        this.monitor.bytesWritten(howManyBytesToWrite);
        this.clearInternalBuffer();
    }

    public int write(ReadableByteChannel data) throws IOException {
        int result = 0;
        int bytesRead = 0;
        while ((bytesRead = data.read(this.byteBuffer)) >= 0) {
            this.checkFlush();
            result += bytesRead;
        }
        return result;
    }
}

