/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.queue.BlockingReadHandler;
import org.neo4j.com.ChannelContext;
import org.neo4j.com.ComException;
import org.neo4j.com.ComExceptionHandler;
import org.neo4j.com.Deserializer;
import org.neo4j.com.LoggingResourcePoolMonitor;
import org.neo4j.com.MonitorChannelHandler;
import org.neo4j.com.Protocol;
import org.neo4j.com.Protocol320;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.ResourcePool;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.Serializer;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.util.HexPrinter;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.Clocks;

public abstract class Client<T>
extends LifecycleAdapter
implements ChannelPipelineFactory {
    public static final int DEFAULT_MAX_NUMBER_OF_CONCURRENT_CHANNELS_PER_CLIENT = 20;
    public static final int DEFAULT_READ_RESPONSE_TIMEOUT_SECONDS = 20;
    private static final String BLOCKING_CHANNEL_HANDLER_NAME = "blockingHandler";
    private static final String MONITORING_CHANNEL_HANDLER_NAME = "monitor";
    private ClientBootstrap bootstrap;
    private final SocketAddress destination;
    private final SocketAddress origin;
    private final Log msgLog;
    private ResourcePool<ChannelContext> channelPool;
    private final Protocol protocol;
    private final int frameLength;
    private final long readTimeout;
    private final int maxUnusedChannels;
    private final StoreId storeId;
    private ResourceReleaser resourcePoolReleaser;
    private ComExceptionHandler comExceptionHandler;
    private final ResponseUnpacker responseUnpacker;
    private final ByteCounterMonitor byteCounterMonitor;
    private final RequestMonitor requestMonitor;
    private final LogEntryReader<ReadableClosablePositionAwareChannel> entryReader;

    public Client(String destinationHostNameOrIp, int destinationPort, String originHostNameOrIp, LogProvider logProvider, StoreId storeId, int frameLength, long readTimeout, int maxConcurrentChannels, int chunkSize, ResponseUnpacker responseUnpacker, ByteCounterMonitor byteCounterMonitor, RequestMonitor requestMonitor, LogEntryReader<ReadableClosablePositionAwareChannel> entryReader) {
        this.entryReader = entryReader;
        assert (byteCounterMonitor != null);
        assert (requestMonitor != null);
        this.byteCounterMonitor = byteCounterMonitor;
        this.requestMonitor = requestMonitor;
        Protocol.assertChunkSizeIsWithinFrameSize(chunkSize, frameLength);
        this.msgLog = logProvider.getLog(((Object)((Object)this)).getClass());
        this.storeId = storeId;
        this.frameLength = frameLength;
        this.readTimeout = readTimeout;
        this.maxUnusedChannels = maxConcurrentChannels;
        this.comExceptionHandler = this.getNoOpComExceptionHandler();
        this.destination = destinationHostNameOrIp.equals("0.0.0.0") ? new InetSocketAddress(this.getLocalAddress(), destinationPort) : new InetSocketAddress(destinationHostNameOrIp, destinationPort);
        this.origin = originHostNameOrIp == null || originHostNameOrIp.equals("0.0.0.0") ? null : new InetSocketAddress(originHostNameOrIp, 0);
        ProtocolVersion protocolVersion = this.getProtocolVersion();
        this.protocol = this.createProtocol(chunkSize, protocolVersion.getApplicationProtocol());
        this.responseUnpacker = responseUnpacker;
        this.msgLog.info(((Object)((Object)this)).getClass().getSimpleName() + " communication channel created towards " + this.destination);
    }

    private String getLocalAddress() {
        try {
            return InetAddress.getByName(null).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    private ComExceptionHandler getNoOpComExceptionHandler() {
        return exception -> {
            if (ComException.TRACE_HA_CONNECTIVITY) {
                String noOpComExceptionHandler = "NoOpComExceptionHandler";
                this.traceComException(exception, noOpComExceptionHandler);
            }
        };
    }

    private ComException traceComException(ComException exception, String tracePoint) {
        return exception.traceComException(this.msgLog, tracePoint);
    }

    protected Protocol createProtocol(int chunkSize, byte applicationProtocolVersion) {
        return new Protocol320(chunkSize, applicationProtocolVersion, this.getInternalProtocolVersion());
    }

    public abstract ProtocolVersion getProtocolVersion();

    public void start() {
        this.bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool((ThreadFactory)NamedThreadFactory.daemon((String)(((Object)((Object)this)).getClass().getSimpleName() + "-boss@" + this.destination))), (Executor)Executors.newCachedThreadPool((ThreadFactory)NamedThreadFactory.daemon((String)(((Object)((Object)this)).getClass().getSimpleName() + "-worker@" + this.destination)))));
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)this);
        this.channelPool = new ResourcePool<ChannelContext>(this.maxUnusedChannels, (ResourcePool.CheckStrategy)new ResourcePool.CheckStrategy.TimeoutCheckStrategy(60000L, Clocks.systemClock()), (ResourcePool.Monitor)new LoggingResourcePoolMonitor(this.msgLog)){

            @Override
            protected ChannelContext create() {
                Client.this.msgLog.info(this.threadInfo() + "Trying to open a new channel from " + Client.this.origin + " to " + Client.this.destination, new Object[]{true});
                ChannelFuture channelFuture = Client.this.bootstrap.connect(Client.this.destination, Client.this.origin);
                channelFuture.awaitUninterruptibly(5L, TimeUnit.SECONDS);
                if (channelFuture.isSuccess()) {
                    Client.this.msgLog.info(this.threadInfo() + "Opened a new channel from " + channelFuture.getChannel().getLocalAddress() + " to " + channelFuture.getChannel().getRemoteAddress());
                    return new ChannelContext(channelFuture.getChannel(), ChannelBuffers.dynamicBuffer(), ByteBuffer.allocate(0x100000));
                }
                Throwable cause = channelFuture.getCause();
                String msg = ((Object)((Object)Client.this)).getClass().getSimpleName() + " could not connect from " + Client.this.origin + " to " + Client.this.destination;
                Client.this.msgLog.debug(msg, new Object[]{true});
                throw Client.this.traceComException(new ComException(msg, cause), "Client.start");
            }

            @Override
            protected boolean isAlive(ChannelContext context) {
                return context.channel().isConnected();
            }

            @Override
            protected void dispose(ChannelContext context) {
                Channel channel = context.channel();
                if (channel.isConnected()) {
                    Client.this.msgLog.info(this.threadInfo() + "Closing: " + context + ". Channel pool size is now " + this.currentSize());
                    channel.close();
                }
            }

            private String threadInfo() {
                return "Thread[" + Thread.currentThread().getId() + ", " + Thread.currentThread().getName() + "] ";
            }
        };
        this.resourcePoolReleaser = () -> {
            if (this.channelPool != null) {
                this.channelPool.release();
            }
        };
    }

    public void stop() {
        if (this.channelPool != null) {
            this.channelPool.close(true);
            this.bootstrap.releaseExternalResources();
            this.channelPool = null;
        }
        this.comExceptionHandler = this.getNoOpComExceptionHandler();
        this.msgLog.info(this.toString() + " shutdown", new Object[]{true});
    }

    protected <R> Response<R> sendRequest(RequestType<T> type, RequestContext context, Serializer serializer, Deserializer<R> deserializer) {
        return this.sendRequest(type, context, serializer, deserializer, null, ResponseUnpacker.TxHandler.NO_OP_TX_HANDLER);
    }

    protected <R> Response<R> sendRequest(RequestType<T> type, RequestContext context, Serializer serializer, Deserializer<R> deserializer, StoreId specificStoreId, ResponseUnpacker.TxHandler txHandler) {
        ChannelContext channelContext = this.acquireChannelContext(type);
        Throwable failure = null;
        try {
            this.requestMonitor.beginRequest(channelContext.channel().getRemoteAddress(), type, context);
            this.protocol.serializeRequest(channelContext.channel(), channelContext.output(), type, context, serializer);
            Response<R> response = this.protocol.deserializeResponse(Client.extractBlockingReadHandler(channelContext), channelContext.input(), this.getReadTimeout(type, this.readTimeout), deserializer, this.resourcePoolReleaser, this.entryReader);
            if (type.responseShouldBeUnpacked()) {
                this.responseUnpacker.unpackResponse(response, txHandler);
            }
            if (this.shouldCheckStoreId(type)) {
                if (specificStoreId != null) {
                    this.assertCorrectStoreId(response.getStoreId(), specificStoreId);
                } else {
                    this.assertCorrectStoreId(response.getStoreId(), this.storeId);
                }
            }
            Response<R> response2 = response;
            return response2;
        }
        catch (ComException e) {
            failure = e;
            this.comExceptionHandler.handle(e);
            throw this.traceComException(e, "Client.sendRequest");
        }
        catch (Throwable e) {
            failure = e;
            throw (ComException)Exceptions.launderedException(ComException.class, (Throwable)e);
        }
        finally {
            if (failure != null) {
                this.dispose(channelContext);
            }
            this.requestMonitor.endRequest(failure);
        }
    }

    protected long getReadTimeout(RequestType<T> type, long readTimeout) {
        return readTimeout;
    }

    protected boolean shouldCheckStoreId(RequestType<T> type) {
        return true;
    }

    protected StoreId getStoreId() {
        return this.storeId;
    }

    private void assertCorrectStoreId(StoreId storeId, StoreId myStoreId) {
        if (!myStoreId.equals((Object)storeId)) {
            throw new MismatchingStoreIdException(myStoreId, storeId);
        }
    }

    private ChannelContext acquireChannelContext(RequestType<T> type) {
        try {
            if (this.channelPool == null) {
                throw new ComException(String.format("Client for %s is stopped", this.destination.toString()));
            }
            ChannelContext result = this.channelPool.acquire();
            if (result == null) {
                this.msgLog.error("Unable to acquire new channel for " + type);
                throw this.traceComException(new ComException("Unable to acquire new channel for " + type), "Client.acquireChannelContext");
            }
            return result;
        }
        catch (Throwable e) {
            throw (ComException)Exceptions.launderedException(ComException.class, (Throwable)e);
        }
    }

    private void dispose(ChannelContext channelContext) {
        channelContext.channel().close().awaitUninterruptibly();
        if (this.channelPool != null) {
            this.channelPool.release();
        }
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast(MONITORING_CHANNEL_HANDLER_NAME, (ChannelHandler)new MonitorChannelHandler(this.byteCounterMonitor));
        Protocol.addLengthFieldPipes(pipeline, this.frameLength);
        BlockingReadHandler reader = new BlockingReadHandler(new ArrayBlockingQueue(100, false));
        pipeline.addLast(BLOCKING_CHANNEL_HANDLER_NAME, (ChannelHandler)reader);
        return pipeline;
    }

    public void setComExceptionHandler(ComExceptionHandler handler) {
        this.comExceptionHandler = handler == null ? this.getNoOpComExceptionHandler() : handler;
    }

    protected byte getInternalProtocolVersion() {
        return 2;
    }

    private static BlockingReadHandler<ChannelBuffer> extractBlockingReadHandler(ChannelContext channelContext) {
        ChannelPipeline pipeline = channelContext.channel().getPipeline();
        return (BlockingReadHandler)pipeline.get(BLOCKING_CHANNEL_HANDLER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String beginningOfBufferAsHexString(ChannelBuffer buffer, int maxBytesToPrint) {
        int prevIndex = buffer.readerIndex();
        buffer.readerIndex(0);
        try {
            ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream(buffer.readableBytes());
            PrintStream stream = new PrintStream(byteArrayStream);
            HexPrinter printer = new HexPrinter(stream).withLineNumberDigits(4);
            for (int i = 0; buffer.readable() && i < maxBytesToPrint; ++i) {
                printer.append(buffer.readByte());
            }
            stream.flush();
            String string = byteArrayStream.toString();
            return string;
        }
        finally {
            buffer.readerIndex(prevIndex);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.destination + "]";
    }
}

