/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.IOException;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.ServerFailureException;
import org.neo4j.com.TransactionObligationResponse;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;

public abstract class Response<T>
implements AutoCloseable {
    private final T response;
    private final StoreId storeId;
    private final ResourceReleaser releaser;
    public static final Response<Void> EMPTY = new TransactionObligationResponse<Object>(null, StoreId.DEFAULT, -1L, ResourceReleaser.NO_OP);

    public Response(T response, StoreId storeId, ResourceReleaser releaser) {
        this.storeId = storeId;
        this.response = response;
        this.releaser = releaser;
    }

    public T response() throws ServerFailureException {
        return this.response;
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    @Override
    public void close() {
        this.releaser.release();
    }

    public static <T> Response<T> empty() {
        return EMPTY;
    }

    public abstract void accept(Handler var1) throws Exception;

    public abstract boolean hasTransactionsToBeApplied();

    public static interface Handler {
        public void obligation(long var1) throws IOException;

        public Visitor<CommittedTransactionRepresentation, Exception> transactions();
    }
}

