/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.neo4j.com.Response;
import org.neo4j.com.storecopy.ExternallyManagedPageCache;
import org.neo4j.com.storecopy.FileMoveAction;
import org.neo4j.com.storecopy.MoveAfterCopy;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.com.storecopy.ToFileStoreWriter;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyLogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class StoreCopyClient {
    private final File storeDir;
    private final Config config;
    private final Iterable<KernelExtensionFactory<?>> kernelExtensions;
    private final Log log;
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final Monitor monitor;
    private final boolean forensics;

    public StoreCopyClient(File storeDir, Config config, Iterable<KernelExtensionFactory<?>> kernelExtensions, LogProvider logProvider, FileSystemAbstraction fs, PageCache pageCache, Monitor monitor, boolean forensics) {
        this.storeDir = storeDir;
        this.config = config;
        this.kernelExtensions = kernelExtensions;
        this.log = logProvider.getLog(this.getClass());
        this.fs = fs;
        this.pageCache = pageCache;
        this.monitor = monitor;
        this.forensics = forensics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStore(StoreCopyRequester requester, CancellationRequest cancellationRequest, MoveAfterCopy moveAfterCopy) throws Exception {
        File tempStore = new File(this.storeDir, "temp-copy");
        try {
            ArrayList<FileMoveAction> storeFileMoveActions = new ArrayList<FileMoveAction>();
            this.cleanDirectory(tempStore);
            this.monitor.startReceivingStoreFiles();
            try (Response<?> response = requester.copyStore(this.decorateWithProgressIndicator(new ToFileStoreWriter(tempStore, this.fs, this.monitor, this.pageCache, storeFileMoveActions)));){
                this.monitor.finishReceivingStoreFiles();
                this.writeTransactionsToActiveLogFile(tempStore, response);
            }
            finally {
                requester.done();
            }
            this.checkCancellation(cancellationRequest, tempStore);
            this.monitor.startRecoveringStore();
            GraphDatabaseService graphDatabaseService = this.newTempDatabase(tempStore);
            graphDatabaseService.shutdown();
            this.monitor.finishRecoveringStore();
            Stream<FileMoveAction> moveActionStream = Stream.concat(storeFileMoveActions.stream(), StoreCopyClient.traverseGenerateMoveActions(tempStore, tempStore));
            moveAfterCopy.move(moveActionStream, tempStore, this.storeDir);
        }
        finally {
            FileUtils.deleteRecursively((File)tempStore);
        }
    }

    private static Stream<FileMoveAction> traverseGenerateMoveActions(File dir, File basePath) {
        return Stream.of(dir).flatMap(d -> StoreCopyClient.expandTraverseFiles(d, basePath));
    }

    private static Stream<FileMoveAction> expandTraverseFiles(File dir, File basePath) {
        File[] listing = dir.listFiles();
        if (listing == null) {
            return dir.isFile() ? Stream.of(FileMoveAction.copyViaFileSystem(dir, basePath)) : null;
        }
        Stream<File> files = Arrays.stream(listing).filter(File::isFile);
        Stream<File> dirs = Arrays.stream(listing).filter(File::isDirectory);
        Stream<FileMoveAction> moveFiles = files.map(f -> FileMoveAction.copyViaFileSystem(f, basePath));
        Stream traverseDirectories = dirs.flatMap(d -> StoreCopyClient.traverseGenerateMoveActions(d, basePath));
        return Stream.concat(moveFiles, traverseDirectories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTransactionsToActiveLogFile(File tempStoreDir, Response<?> response) throws Exception {
        LifeSupport life = new LifeSupport();
        try {
            PhysicalLogFiles logFiles = new PhysicalLogFiles(tempStoreDir, this.fs);
            LogHeaderCache logHeaderCache = new LogHeaderCache(10);
            ReadOnlyLogVersionRepository logVersionRepository = new ReadOnlyLogVersionRepository(this.pageCache, tempStoreDir);
            ReadOnlyTransactionIdStore readOnlyTransactionIdStore = new ReadOnlyTransactionIdStore(this.pageCache, tempStoreDir);
            LogFile logFile = (LogFile)life.add((Lifecycle)new PhysicalLogFile(this.fs, logFiles, Long.MAX_VALUE, () -> ((ReadOnlyTransactionIdStore)readOnlyTransactionIdStore).getLastCommittedTransactionId(), (LogVersionRepository)logVersionRepository, (PhysicalLogFile.Monitor)new Monitors().newMonitor(PhysicalLogFile.Monitor.class, new String[0]), logHeaderCache));
            life.start();
            FlushablePositionAwareChannel channel = logFile.getWriter();
            final TransactionLogWriter writer = new TransactionLogWriter(new LogEntryWriter((FlushableChannel)channel));
            final AtomicLong firstTxId = new AtomicLong(1L);
            response.accept(new Response.Handler(){

                @Override
                public void obligation(long txId) throws IOException {
                    throw new UnsupportedOperationException("Shouldn't be called");
                }

                @Override
                public Visitor<CommittedTransactionRepresentation, Exception> transactions() {
                    return transaction -> {
                        long txId = transaction.getCommitEntry().getTxId();
                        if (firstTxId.compareAndSet(1L, txId)) {
                            StoreCopyClient.this.monitor.startReceivingTransactions(txId);
                        }
                        writer.append(transaction.getTransactionRepresentation(), txId);
                        return false;
                    };
                }
            });
            long endTxId = firstTxId.get();
            if (endTxId != 1L) {
                this.monitor.finishReceivingTransactions(endTxId);
            }
            long currentLogVersion = logVersionRepository.getCurrentLogVersion();
            writer.checkPoint(new LogPosition(currentLogVersion, 16L));
            File currentLogFile = logFiles.getLogFileForVersion(currentLogVersion);
            LogHeaderWriter.writeLogHeader((FileSystemAbstraction)this.fs, (File)currentLogFile, (long)currentLogVersion, (long)Math.max(1L, endTxId - 1L));
            if (!this.forensics) {
                File neoStore = new File(tempStoreDir, "neostore");
                MetaDataStore.setRecord((PageCache)this.pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, (long)16L);
            }
        }
        finally {
            life.shutdown();
        }
    }

    private GraphDatabaseService newTempDatabase(File tempStore) {
        ExternallyManagedPageCache.GraphDatabaseFactoryWithPageCacheFactory factory = ExternallyManagedPageCache.graphDatabaseFactoryWithPageCache(this.pageCache);
        return factory.setKernelExtensions(this.kernelExtensions).setUserLogProvider((LogProvider)NullLogProvider.getInstance()).newEmbeddedDatabaseBuilder(tempStore.getAbsoluteFile()).setConfig(GraphDatabaseSettings.label_index, GraphDatabaseSettings.LabelIndex.AUTO.name()).setConfig("dbms.backup.enabled", "false").setConfig(GraphDatabaseSettings.logs_directory, tempStore.getAbsolutePath()).setConfig(GraphDatabaseSettings.keep_logical_logs, "true").setConfig(GraphDatabaseSettings.allow_store_upgrade, ((Boolean)this.config.get(GraphDatabaseSettings.allow_store_upgrade)).toString()).newGraphDatabase();
    }

    private StoreWriter decorateWithProgressIndicator(final StoreWriter actual) {
        return new StoreWriter(){
            private int totalFiles;

            @Override
            public long write(String path, ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData, int requiredElementAlignment) throws IOException {
                StoreCopyClient.this.log.info("Copying %s", new Object[]{path});
                long written = actual.write(path, data, temporaryBuffer, hasData, requiredElementAlignment);
                StoreCopyClient.this.log.info("Copied %s %s", new Object[]{path, Format.bytes((long)written)});
                ++this.totalFiles;
                return written;
            }

            @Override
            public void close() {
                actual.close();
                StoreCopyClient.this.log.info("Done, copied %s files", new Object[]{this.totalFiles});
            }
        };
    }

    private void cleanDirectory(File directory) throws IOException {
        if (!directory.mkdir()) {
            FileUtils.deleteRecursively((File)directory);
            directory.mkdir();
        }
    }

    private void checkCancellation(CancellationRequest cancellationRequest, File tempStore) throws IOException {
        if (cancellationRequest.cancellationRequested()) {
            this.log.info("Store copying was cancelled. Cleaning up temp-directories.");
            this.cleanDirectory(tempStore);
        }
    }

    public static interface StoreCopyRequester {
        public Response<?> copyStore(StoreWriter var1) throws IOException;

        public void done();
    }

    public static interface Monitor {
        public void startReceivingStoreFiles();

        public void finishReceivingStoreFiles();

        public void startReceivingStoreFile(File var1);

        public void finishReceivingStoreFile(File var1);

        public void startReceivingTransactions(long var1);

        public void finishReceivingTransactions(long var1);

        public void startRecoveringStore();

        public void finishRecoveringStore();

        public static class Adapter
        implements Monitor {
            @Override
            public void startReceivingStoreFiles() {
            }

            @Override
            public void finishReceivingStoreFiles() {
            }

            @Override
            public void startReceivingStoreFile(File file) {
            }

            @Override
            public void finishReceivingStoreFile(File file) {
            }

            @Override
            public void startReceivingTransactions(long startTxId) {
            }

            @Override
            public void finishReceivingTransactions(long endTxId) {
            }

            @Override
            public void startRecoveringStore() {
            }

            @Override
            public void finishRecoveringStore() {
            }
        }
    }
}

