/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.neo4j.com.storecopy.FileMoveAction;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.StoreType;

public class ToFileStoreWriter
implements StoreWriter {
    private final File basePath;
    private final FileSystemAbstraction fs;
    private final StoreCopyClient.Monitor monitor;
    private final PageCache pageCache;
    private final List<FileMoveAction> fileMoveActions;

    public ToFileStoreWriter(File graphDbStoreDir, FileSystemAbstraction fs, StoreCopyClient.Monitor monitor, PageCache pageCache, List<FileMoveAction> fileMoveActions) {
        this.basePath = graphDbStoreDir;
        this.fs = fs;
        this.monitor = monitor;
        this.pageCache = pageCache;
        this.fileMoveActions = fileMoveActions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long write(String path, ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData, int requiredElementAlignment) throws IOException {
        try {
            temporaryBuffer.clear();
            File file = new File(this.basePath, path);
            file.getParentFile().mkdirs();
            String filename = file.getName();
            this.monitor.startReceivingStoreFile(file);
            try {
                if (StoreType.shouldBeManagedByPageCache((String)filename)) {
                    int filePageSize = this.filePageSize(requiredElementAlignment);
                    try (PagedFile pagedFile = this.pageCache.map(file, filePageSize, new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE});){
                        long written = this.writeDataThroughPageCache(pagedFile, data, temporaryBuffer, hasData);
                        this.addPageCacheMoveAction(file);
                        long l = written;
                        return l;
                    }
                }
                long l = this.writeDataThroughFileSystem(file, data, temporaryBuffer, hasData);
                return l;
            }
            finally {
                this.monitor.finishReceivingStoreFile(file);
            }
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    private void addPageCacheMoveAction(File file) {
        this.fileMoveActions.add(FileMoveAction.copyViaPageCache(file, this.pageCache));
    }

    private int filePageSize(int alignment) {
        int pageCacheSize = this.pageCache.pageSize();
        return alignment == 1 ? pageCacheSize : pageCacheSize - pageCacheSize % alignment;
    }

    private long writeDataThroughFileSystem(File file, ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData) throws IOException {
        try (StoreChannel channel = this.fs.create(file);){
            long l = this.writeData(data, temporaryBuffer, hasData, (WritableByteChannel)channel);
            return l;
        }
    }

    private long writeDataThroughPageCache(PagedFile pagedFile, ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData) throws IOException {
        try (WritableByteChannel channel = pagedFile.openWritableByteChannel();){
            long l = this.writeData(data, temporaryBuffer, hasData, channel);
            return l;
        }
    }

    private long writeData(ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData, WritableByteChannel channel) throws IOException {
        long totalToWrite = 0L;
        long totalWritten = 0L;
        if (hasData) {
            while (data.read(temporaryBuffer) >= 0) {
                int bytesWritten;
                temporaryBuffer.flip();
                totalToWrite += (long)temporaryBuffer.limit();
                while ((totalWritten += (long)(bytesWritten = channel.write(temporaryBuffer))) < totalToWrite) {
                    if (bytesWritten >= 0) continue;
                    throw new IOException("Unable to write to disk, reported bytes written was " + bytesWritten);
                }
                temporaryBuffer.clear();
            }
        }
        return totalWritten;
    }

    @Override
    public void close() {
    }
}

