/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import org.neo4j.helpers.Format;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionQueue;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.logging.Log;
import org.neo4j.storageengine.api.TransactionApplicationMode;

class TransactionBatchCommitter
implements TransactionQueue.Applier {
    private final KernelTransactions kernelTransactions;
    private final long idReuseSafeZoneTime;
    private final TransactionCommitProcess commitProcess;
    private final Log log;

    TransactionBatchCommitter(KernelTransactions kernelTransactions, long idReuseSafeZoneTime, TransactionCommitProcess commitProcess, Log log) {
        assert (log != null);
        this.kernelTransactions = kernelTransactions;
        this.idReuseSafeZoneTime = idReuseSafeZoneTime;
        this.commitProcess = commitProcess;
        this.log = log;
    }

    public void apply(TransactionToApply first, TransactionToApply last) throws Exception {
        if (this.batchSizeExceedsSafeZone(first, last)) {
            this.kernelTransactions.blockNewTransactions();
            try {
                this.markUnsafeTransactionsForTermination(first, last);
                this.commit(first);
            }
            finally {
                this.kernelTransactions.unblockNewTransactions();
            }
        } else {
            this.markUnsafeTransactionsForTermination(first, last);
            this.commit(first);
        }
    }

    private long commit(TransactionToApply first) throws TransactionFailureException {
        return this.commitProcess.commit(first, CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
    }

    private boolean batchSizeExceedsSafeZone(TransactionToApply first, TransactionToApply last) {
        long firstAppliedTimestamp;
        long lastAppliedTimestamp = last.transactionRepresentation().getTimeCommitted();
        long chunkLength = lastAppliedTimestamp - (firstAppliedTimestamp = first.transactionRepresentation().getTimeCommitted());
        return chunkLength > this.idReuseSafeZoneTime;
    }

    private void markUnsafeTransactionsForTermination(TransactionToApply first, TransactionToApply last) {
        long firstCommittedTimestamp = first.transactionRepresentation().getTimeCommitted();
        long lastCommittedTimestamp = last.transactionRepresentation().getTimeCommitted();
        long earliestSafeTimestamp = lastCommittedTimestamp - this.idReuseSafeZoneTime;
        for (KernelTransactionHandle txHandle : this.kernelTransactions.activeTransactions()) {
            long commitTimestamp = txHandle.lastTransactionTimestampWhenStarted();
            if (commitTimestamp == 0L || commitTimestamp >= earliestSafeTimestamp) continue;
            this.log.info("Marking transaction for termination, invalidated due to an upcoming batch of changes being applied:\n  Batch: firstCommittedTxId:" + first.transactionId() + ", firstCommittedTimestamp:" + TransactionBatchCommitter.informativeTimestamp(firstCommittedTimestamp) + ", lastCommittedTxId:" + last.transactionId() + ", lastCommittedTimestamp:" + TransactionBatchCommitter.informativeTimestamp(lastCommittedTimestamp) + ", batchTimeRange:" + TransactionBatchCommitter.informativeDuration(lastCommittedTimestamp - firstCommittedTimestamp) + ", earliestSafeTimstamp:" + TransactionBatchCommitter.informativeTimestamp(earliestSafeTimestamp) + ", safeZoneDuration:" + TransactionBatchCommitter.informativeDuration(this.idReuseSafeZoneTime) + "\n  Transaction: lastCommittedTimestamp:" + TransactionBatchCommitter.informativeTimestamp(txHandle.lastTransactionTimestampWhenStarted()) + ", lastCommittedTxId:" + txHandle.lastTransactionIdWhenStarted() + ", localStartTimestamp:" + TransactionBatchCommitter.informativeTimestamp(txHandle.startTime()));
            txHandle.markForTermination((Status)Status.Transaction.Outdated);
        }
    }

    private static String informativeDuration(long duration) {
        return Format.duration((long)duration) + "/" + duration;
    }

    private static String informativeTimestamp(long timestamp) {
        return Format.time((long)timestamp) + "/" + timestamp;
    }
}

