/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.Usage;

public class HelpCommand
implements AdminCommand {
    private final Usage usage;
    private final Consumer<String> output;
    private final CommandLocator locator;

    HelpCommand(Usage usage, Consumer<String> output, CommandLocator locator) {
        this.usage = usage;
        this.output = output;
        this.locator = locator;
    }

    @Override
    public void execute(String ... args) throws IncorrectUsage {
        if (args.length > 0) {
            try {
                AdminCommand.Provider commandProvider2 = this.locator.findProvider(args[0]);
                this.usage.printUsageForCommand(commandProvider2, this.output);
            }
            catch (NoSuchElementException e) {
                StringBuilder validCommands = new StringBuilder();
                this.locator.getAllProviders().forEach(commandProvider -> validCommands.append(commandProvider.name()).append(" "));
                throw new IncorrectUsage(String.format("Unknown command: %s. Available commands are: %s\n", args[0], validCommands));
            }
        } else {
            this.usage.print(this.output);
        }
    }
}

