/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cli;

import org.neo4j.configuration.helpers.DatabaseNameValidator;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.io.ByteUnit;
import picocli.CommandLine;

public interface Converters {

    public static class DatabaseNameConverter
    implements CommandLine.ITypeConverter<NormalizedDatabaseName> {
        public NormalizedDatabaseName convert(String name) {
            try {
                NormalizedDatabaseName databaseName = new NormalizedDatabaseName(name);
                DatabaseNameValidator.validateInternalDatabaseName((NormalizedDatabaseName)databaseName);
                return databaseName;
            }
            catch (Exception e) {
                throw new CommandLine.TypeConversionException(String.format("Invalid database name '%s'. (%s)", name, e));
            }
        }
    }

    public static class ByteUnitConverter
    implements CommandLine.ITypeConverter<Long> {
        public Long convert(String value) {
            try {
                return ByteUnit.parse((String)value);
            }
            catch (Exception e) {
                throw new CommandLine.TypeConversionException(String.format("cannot convert '%s' to byte units (%s)", value, e));
            }
        }
    }
}

