/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.Arrays;
import java.util.Random;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.impl.factory.primitive.CharLists;
import org.eclipse.collections.impl.factory.primitive.CharSets;
import org.junit.jupiter.api.Test;
import org.neo4j.util.CharRangeSet;

class CharRangeSetTest {
    CharRangeSetTest() {
    }

    @Test
    void empty() {
        CharRangeSet set = new CharRangeSet(new char[0]);
        Assertions.assertThat((int)set.size()).isZero();
        Assertions.assertThat((boolean)set.contains(new Random().nextInt())).isFalse();
    }

    @Test
    void randomRanges() {
        long seed = new Random().nextLong();
        Random rand = new Random(seed);
        CharSet baseline = this.randomCharSet(rand);
        CharRangeSet set = this.from(baseline);
        ((AbstractIntegerAssert)Assertions.assertThat((int)set.size()).describedAs("seed %s: %s", new Object[]{seed, set})).isEqualTo(baseline.size());
        for (char i = '\u0000'; i < '\uffff'; i = (char)(i + '\u0001')) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)set.contains(i)).describedAs("seed %s: %s contains %s", new Object[]{seed, set, Character.valueOf(i)})).isEqualTo(baseline.contains(i));
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)set.contains(-1)).describedAs("seed %s: %s", new Object[]{seed, set})).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)set.contains(65536)).describedAs("seed %s: %s", new Object[]{seed, set})).isFalse();
    }

    private CharSet randomCharSet(Random rand) {
        MutableCharSet result = CharSets.mutable.empty();
        int max = rand.nextInt(65535) + 1;
        int sizeHint = rand.nextInt(5000);
        for (int i = 0; i < sizeHint; ++i) {
            result.add((char)rand.nextInt(max));
        }
        return result;
    }

    private CharRangeSet from(CharSet set) {
        char[] array = set.toArray();
        Arrays.sort(array);
        MutableCharList result = CharLists.mutable.empty();
        for (int i = 0; i < array.length; ++i) {
            char from = array[i];
            while (array[i] == array[i] + '\u0001') {
                ++i;
            }
            result.addAll(new char[]{from, array[i]});
        }
        return new CharRangeSet(result.toArray());
    }
}

