/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.common;

import java.util.function.IntFunction;
import org.neo4j.common.EntityType;

public interface TokenNameLookup {
    public String labelGetName(int var1);

    public String relationshipTypeGetName(int var1);

    public String propertyKeyGetName(int var1);

    default public String[] entityTokensGetNames(EntityType type, int[] entityTokenIds) {
        IntFunction<String> mapper = switch (type) {
            default -> throw new MatchException(null, null);
            case EntityType.NODE -> this::labelGetName;
            case EntityType.RELATIONSHIP -> this::relationshipTypeGetName;
        };
        String[] tokenNames = new String[entityTokenIds.length];
        for (int i = 0; i < entityTokenIds.length; ++i) {
            tokenNames[i] = mapper.apply(entityTokenIds[i]);
        }
        return tokenNames;
    }
}

