/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

public enum CypherVersion {
    Cypher5("5", "CYPHER 5", false, "cypher-5"),
    Cypher25("25", "CYPHER 25", true, "cypher-25");

    public static final CypherVersion Default;
    public final String versionName;
    public final String description;
    public final boolean experimental;
    public final String persistedValue;

    private CypherVersion(String versionName, String description, boolean experimental, String persistedValue) {
        this.versionName = versionName;
        this.description = description;
        this.experimental = experimental;
        this.persistedValue = persistedValue;
    }

    public String toString() {
        return this.versionName;
    }

    public static CypherVersion fromStoredValue(String storedValue) {
        for (CypherVersion version : CypherVersion.values()) {
            if (!version.persistedValue.equals(storedValue)) continue;
            return version;
        }
        throw new IllegalArgumentException(storedValue + " is not a valid CypherVersion");
    }

    static {
        Default = Cypher5;
    }
}

