/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.NameUtil;

public class NameUtilTest {
    @Test
    void escapeNonAlphanumericStrings() {
        Assertions.assertThat((String)NameUtil.escapeName((String)"abc12_A")).isEqualTo("abc12_A");
        Assertions.assertThat((String)NameUtil.escapeName((String)"\u00c5bc12_A")).isEqualTo("\u00c5bc12_A");
        Assertions.assertThat((String)NameUtil.escapeName((String)"\u0000")).isEqualTo("`\u0000`");
        Assertions.assertThat((String)NameUtil.escapeName((String)"\n")).isEqualTo("`\n`");
        Assertions.assertThat((String)NameUtil.escapeName((String)"comma, separated")).isEqualTo("`comma, separated`");
        Assertions.assertThat((String)NameUtil.escapeName((String)"escaped content `back ticks #")).isEqualTo("`escaped content ``back ticks #`");
        Assertions.assertThat((String)NameUtil.escapeName((String)"escaped content two `back `ticks")).isEqualTo("`escaped content two ``back ``ticks`");
    }

    @Test
    void forceEscapeNonAlphanumericStrings() {
        Assertions.assertThat((String)NameUtil.forceEscapeName((String)"abc12_A")).isEqualTo("`abc12_A`");
        Assertions.assertThat((String)NameUtil.escapeName((String)"\u0000")).isEqualTo("`\u0000`");
    }

    @Test
    void escapeAndReplaceUnicodeBackticks() {
        Assertions.assertThat((String)NameUtil.forceEscapeName((String)"\\u0060")).isEqualTo("````");
        Assertions.assertThat((String)NameUtil.forceEscapeName((String)"\\uuuuu0060")).isEqualTo("````");
        Assertions.assertThat((String)NameUtil.forceEscapeName((String)"T\\u0060est")).isEqualTo("`T``est`");
    }

    @Test
    void escapeSingleQuotesAlphanumericStrings() {
        Assertions.assertThat((String)NameUtil.escapeSingleQuotes((String)"\\'test'")).isEqualTo("\\\\\\'test\\'");
    }

    @Test
    void escapeDoubleQuotesAlphanumericStrings() {
        Assertions.assertThat((String)NameUtil.escapeDoubleQuotes((String)"\\\"test\"")).isEqualTo("\\\\\\\"test\\\"");
    }

    @Test
    void reEscapeNonAlphanumericStrings() {
        Assertions.assertThat((String)NameUtil.unescapeName((String)"abc12_A")).isEqualTo("abc12_A");
        Assertions.assertThat((String)NameUtil.unescapeName((String)"\u00c5bc12_A")).isEqualTo("\u00c5bc12_A");
        Assertions.assertThat((String)NameUtil.unescapeName((String)"`\u0000`")).isEqualTo("\u0000");
        Assertions.assertThat((String)NameUtil.unescapeName((String)"`\n`")).isEqualTo("\n");
        Assertions.assertThat((String)NameUtil.unescapeName((String)"`comma, separated`")).isEqualTo("comma, separated");
        Assertions.assertThat((String)NameUtil.unescapeName((String)"`escaped content ``back ticks #`")).isEqualTo("escaped content `back ticks #");
        Assertions.assertThat((String)NameUtil.unescapeName((String)"`escaped content two ``back ``ticks`")).isEqualTo("escaped content two `back `ticks");
    }

    @Test
    void escapeNonGlobStrings() {
        Assertions.assertThat((String)NameUtil.escapeGlob((String)"abc.1?2_A")).isEqualTo("abc.1?2_A");
        Assertions.assertThat((String)NameUtil.escapeGlob((String)"\u00c5bc*12_A")).isEqualTo("\u00c5bc*12_A");
        Assertions.assertThat((String)NameUtil.escapeGlob((String)"*")).isEqualTo("*");
        Assertions.assertThat((String)NameUtil.escapeGlob((String)"?")).isEqualTo("?");
        Assertions.assertThat((String)NameUtil.escapeGlob((String)"abc.glob")).isEqualTo("abc.glob");
        Assertions.assertThat((String)NameUtil.escapeGlob((String)".glob")).isEqualTo("`.glob`");
        Assertions.assertThat((String)NameUtil.escapeGlob((String)"\u0000")).isEqualTo("`\u0000`");
        Assertions.assertThat((String)NameUtil.escapeGlob((String)"\n")).isEqualTo("`\n`");
        Assertions.assertThat((String)NameUtil.escapeGlob((String)"comma, separated")).isEqualTo("`comma, separated`");
        Assertions.assertThat((String)NameUtil.escapeGlob((String)"escaped content `back ticks #")).isEqualTo("`escaped content ``back ticks #`");
        Assertions.assertThat((String)NameUtil.escapeGlob((String)"escaped content two `back `ticks")).isEqualTo("`escaped content two ``back ``ticks`");
    }
}

