/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobHandles;

class JobHandlesTest {
    JobHandlesTest() {
    }

    @Test
    void shouldPassThroughSpecifiedException() throws Exception {
        JobHandle failingJob = (JobHandle)Mockito.mock(JobHandle.class);
        Mockito.when((Object)((Void)failingJob.get())).thenThrow(new Throwable[]{new ExecutionException(new IOException())});
        Assertions.assertThatThrownBy(() -> JobHandles.getAllResults(List.of(failingJob), IOException.class, RuntimeException::new)).isInstanceOf(IOException.class);
    }

    @Test
    void shouldUseFallbackExceptionWrap() throws Exception {
        JobHandle failingJob = (JobHandle)Mockito.mock(JobHandle.class);
        Mockito.when((Object)((Void)failingJob.get())).thenThrow(new Throwable[]{new ExecutionException(new ArrayIndexOutOfBoundsException())});
        Assertions.assertThatThrownBy(() -> JobHandles.getAllResults(List.of(failingJob), IOException.class, IllegalStateException::new)).isInstanceOf(IllegalStateException.class);
    }
}

