/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util;

import java.util.Arrays;
import java.util.Objects;
import org.neo4j.util.Preconditions;

public class CharRangeSet {
    private final char[] ranges;
    private final char max;

    public CharRangeSet(char[] ranges) {
        Preconditions.checkArgument(ranges.length % 2 == 0, "length needs to be even");
        Preconditions.checkArgument(CharRangeSet.isSorted(ranges), "ranges are sorted");
        this.ranges = ranges;
        this.max = ranges.length != 0 ? ranges[ranges.length - 1] : (char)'\u0000';
    }

    public boolean contains(int codepoint) {
        return codepoint >= 0 && codepoint <= this.max && this.contains((char)codepoint);
    }

    public boolean contains(char c) {
        for (int i = 0; i < this.ranges.length; i += 2) {
            if (c > this.ranges[i + 1]) continue;
            return c >= this.ranges[i];
        }
        return false;
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.ranges.length; i += 2) {
            size += this.ranges[i + 1] - this.ranges[i] + 1;
        }
        return size;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharRangeSet that = (CharRangeSet)o;
        return Objects.deepEquals(this.ranges, that.ranges);
    }

    public int hashCode() {
        return Arrays.hashCode(this.ranges);
    }

    public String toString() {
        return "CharRangeSet{ranges=" + Arrays.toString(this.ranges) + "}";
    }

    private static boolean isSorted(char[] array) {
        for (int i = 0; i < array.length; i += 2) {
            if (array[i] > array[i + 1]) {
                return false;
            }
            if (i + 2 >= array.length || array[i + 1] < array[i + 2]) continue;
            return false;
        }
        return true;
    }
}

