/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.ProcessUtils;

class ProcessUtilsTest {
    private static final String HELLO_WORLD = "Hello World";

    ProcessUtilsTest() {
    }

    public static void main(String[] args) {
        System.out.println(HELLO_WORLD);
    }

    @Test
    void mustFindWorkingJavaExecutableAndClassPath() throws Exception {
        ArrayList<String> command = new ArrayList<String>();
        command.add(ProcessUtils.getJavaExecutable().toString());
        command.add("-cp");
        command.add(ProcessUtils.getClassPath());
        command.add("-XX:-UsePerfData");
        command.add(this.getClass().getName());
        ProcessBuilder builder = new ProcessBuilder(command);
        Process process = builder.start();
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = in.readLine();
        Assertions.assertThat((int)process.waitFor()).isZero();
        Assertions.assertThat((String)line).isEqualTo(HELLO_WORLD);
    }

    @Test
    void startJavaProcessUsingProcessUtil() throws IOException, InterruptedException {
        Process process = ProcessUtils.start(pb -> {}, (String[])new String[]{"-XX:-UsePerfData", this.getClass().getName()});
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = in.readLine();
        Assertions.assertThat((int)process.waitFor()).isZero();
        Assertions.assertThat((String)line).isEqualTo(HELLO_WORLD);
    }
}

