/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.memory.DeduplicateLargeObjectsHeapEstimatorCache;
import org.neo4j.memory.Measurable;

class DeduplicateLargeObjectsHeapEstimatorCacheTest {
    private DeduplicateLargeObjectsHeapEstimatorCache cache;
    private static final long LARGE_OBJECT_THRESHOLD = 65536L;

    DeduplicateLargeObjectsHeapEstimatorCacheTest() {
    }

    @BeforeEach
    void setUp() {
        this.cache = new DeduplicateLargeObjectsHeapEstimatorCache();
    }

    @Test
    void testEstimateBelowThreshold() {
        TestMeasurable smallObject = new TestMeasurable();
        long estimate = 13L;
        long result1 = this.cache.estimatedHeapUsage((Measurable)smallObject, estimate);
        Assertions.assertEquals((long)estimate, (long)result1, (String)"Estimate below threshold should be returned as is");
        long result2 = this.cache.estimatedHeapUsage((Measurable)smallObject, estimate);
        Assertions.assertEquals((long)estimate, (long)result2, (String)"Estimate below threshold should be returned as is");
    }

    @Test
    void testEstimateAboveThresholdCacheHit() {
        TestMeasurable largeObject = new TestMeasurable();
        long estimate = 65536L;
        long result1 = this.cache.estimatedHeapUsage((Measurable)largeObject, estimate);
        Assertions.assertEquals((long)estimate, (long)result1, (String)"Estimate above threshold should be returned as is on first insertion");
        long result2 = this.cache.estimatedHeapUsage((Measurable)largeObject, estimate);
        Assertions.assertEquals((long)0L, (long)result2, (String)"Estimate above threshold should be returned as 0 on cache hit");
        long result3 = this.cache.estimatedHeapUsage((Measurable)largeObject, estimate);
        Assertions.assertEquals((long)0L, (long)result3, (String)"Estimate above threshold should be returned as 0 on cache hit");
    }

    @Test
    void testEvictionOfSmallestEstimatedObjectWithLeastCacheHits() {
        int sizeLimit = 3;
        DeduplicateLargeObjectsHeapEstimatorCache smallCache = new DeduplicateLargeObjectsHeapEstimatorCache(sizeLimit, 65536L);
        TestMeasurable object1 = new TestMeasurable(0x1E0000L);
        TestMeasurable object2 = new TestMeasurable(655360L);
        TestMeasurable object3 = new TestMeasurable(0x140000L);
        TestMeasurable object4 = new TestMeasurable(0x190000L);
        smallCache.estimatedHeapUsage((Measurable)object1, object1.estimatedHeapUsage());
        smallCache.estimatedHeapUsage((Measurable)object2, object2.estimatedHeapUsage());
        smallCache.estimatedHeapUsage((Measurable)object3, object3.estimatedHeapUsage());
        smallCache.estimatedHeapUsage((Measurable)object1, object1.estimatedHeapUsage());
        smallCache.estimatedHeapUsage((Measurable)object2, object2.estimatedHeapUsage());
        smallCache.estimatedHeapUsage((Measurable)object3, object3.estimatedHeapUsage());
        smallCache.estimatedHeapUsage((Measurable)object4, object4.estimatedHeapUsage());
        long result1 = smallCache.estimatedHeapUsage((Measurable)object1, object1.estimatedHeapUsage());
        Assertions.assertEquals((long)0L, (long)result1, (String)"Object1 should still be in cache");
        long result2 = smallCache.estimatedHeapUsage((Measurable)object2, object2.estimatedHeapUsage());
        Assertions.assertNotEquals((long)0L, (long)result2, (String)"Object2 should have been evicted as it had the smallest estimate");
        long result3 = smallCache.estimatedHeapUsage((Measurable)object3, object3.estimatedHeapUsage());
        Assertions.assertEquals((long)0L, (long)result3, (String)"Object3 should still be in cache");
        long result4 = smallCache.estimatedHeapUsage((Measurable)object4, object4.estimatedHeapUsage());
        Assertions.assertNotEquals((long)0L, (long)result4, (String)"Object4 should have been evicted as it had lower hits");
        smallCache.estimatedHeapUsage((Measurable)object4, object4.estimatedHeapUsage());
        smallCache.estimatedHeapUsage((Measurable)object4, object4.estimatedHeapUsage());
        long result5 = smallCache.estimatedHeapUsage((Measurable)object2, object2.estimatedHeapUsage());
        Assertions.assertNotEquals((long)0L, (long)result5, (String)"Object2 should already have been evicted");
        long result6 = smallCache.estimatedHeapUsage((Measurable)object3, object3.estimatedHeapUsage());
        Assertions.assertNotEquals((long)0L, (long)result6, (String)"Object3 should have been evicted as it had the smallest estimate");
    }

    @Test
    void testCacheEvictionOrderOfEqualSizedObjects() {
        int sizeLimit = 2;
        DeduplicateLargeObjectsHeapEstimatorCache smallCache = new DeduplicateLargeObjectsHeapEstimatorCache(sizeLimit, 65536L);
        TestMeasurable object1 = new TestMeasurable();
        TestMeasurable object2 = new TestMeasurable();
        TestMeasurable object3 = new TestMeasurable();
        long estimate = 65536L;
        smallCache.estimatedHeapUsage((Measurable)object1, estimate);
        smallCache.estimatedHeapUsage((Measurable)object2, estimate);
        smallCache.estimatedHeapUsage((Measurable)object3, estimate);
        long result1 = smallCache.estimatedHeapUsage((Measurable)object1, estimate);
        Assertions.assertNotEquals((long)0L, (long)result1, (String)"Object1 should have been evicted before");
        long result2 = smallCache.estimatedHeapUsage((Measurable)object2, estimate);
        Assertions.assertEquals((long)0L, (long)result2, (String)"Object2 should still be in cache");
        long result3 = smallCache.estimatedHeapUsage((Measurable)object3, estimate);
        Assertions.assertNotEquals((long)0L, (long)result3, (String)"Object3 should have been evicted before");
    }

    private static class TestMeasurable
    implements Measurable {
        private final long estimatedHeapUsage;

        public TestMeasurable() {
            this.estimatedHeapUsage = 1337L;
        }

        public TestMeasurable(long estimatedHeapUsage) {
            this.estimatedHeapUsage = estimatedHeapUsage;
        }

        public long estimatedHeapUsage() {
            return this.estimatedHeapUsage;
        }
    }
}

