/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.common.Validator;
import org.neo4j.internal.helpers.Args;

class ArgsTest {
    ArgsTest() {
    }

    @Test
    void shouldInterpretSingleDashAsValue() {
        Args args = Args.parse((String[])new String[]{"-test", "-"});
        String value = args.get("test");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-", (Object)value);
    }

    @Test
    void testInterleavedParametersWithValuesAndNot() {
        String[] line = new String[]{"-host", "machine.foo.com", "-port", "1234", "-v", "-name", "othershell"};
        Args args = Args.parse((String[])line);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"machine.foo.com", (Object)args.get("host", null));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1234", (Object)args.get("port", null));
        org.junit.jupiter.api.Assertions.assertEquals((int)1234, (int)args.getNumber("port", null).intValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"othershell", (Object)args.get("name", null));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)args.has("v"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)args.orphans().isEmpty());
    }

    @Test
    void testInterleavedEqualsArgsAndSplitKeyValue() {
        String[] line = new String[]{"-host=localhost", "-v", "--port", "1234", "param1", "-name=Something", "param2"};
        Args args = Args.parse((String[])line);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"localhost", (Object)args.get("host", null));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)args.has("v"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1234, (int)args.getNumber("port", null).intValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Something", (Object)args.get("name", null));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)args.orphans().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"param1", args.orphans().get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"param2", args.orphans().get(1));
    }

    @Test
    void testParameterWithDashValue() {
        String[] line = new String[]{"-file", "-"};
        Args args = Args.parse((String[])line);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)args.asMap().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-", (Object)args.get("file", null));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)args.orphans().isEmpty());
    }

    @Test
    void testEnum() {
        String[] line = new String[]{"--enum=" + MyEnum.second.name()};
        Args args = Args.parse((String[])line);
        Enum result = args.getEnum(MyEnum.class, "enum", (Enum)MyEnum.first);
        org.junit.jupiter.api.Assertions.assertEquals((Object)((Object)MyEnum.second), (Object)result);
    }

    @Test
    void testEnumWithDefault() {
        String[] line = new String[]{};
        Args args = Args.parse((String[])line);
        MyEnum result = (MyEnum)args.getEnum(MyEnum.class, "enum", (Enum)MyEnum.third);
        org.junit.jupiter.api.Assertions.assertEquals((Object)((Object)MyEnum.third), (Object)((Object)result));
    }

    @Test
    void testEnumWithInvalidValue() {
        String[] line = new String[]{"--myenum=something"};
        Args args = Args.parse((String[])line);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> args.getEnum(MyEnum.class, "myenum", (Enum)MyEnum.third));
    }

    @Test
    void shouldInterpretOption() {
        int expectedValue = 42;
        Args args = Args.parse((String[])new String[]{"--arg", String.valueOf(expectedValue)});
        Validator validator = (Validator)Mockito.mock(Validator.class);
        int value = (Integer)args.interpretOption("arg", key -> {
            throw new IllegalArgumentException("Missing argument '" + key + "'");
        }, Integer::parseInt, new Validator[]{validator});
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedValue, (int)value);
        ((Validator)Mockito.verify((Object)validator)).validate((Object)expectedValue);
    }

    @Test
    void shouldInterpretOrphan() {
        int expectedValue = 42;
        Args args = Args.parse((String[])new String[]{String.valueOf(expectedValue)});
        Validator validator = (Validator)Mockito.mock(Validator.class);
        int value = (Integer)args.interpretOrphan(0, key -> {
            throw new IllegalArgumentException("Missing argument '" + key + "'");
        }, Integer::parseInt, new Validator[]{validator});
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedValue, (int)value);
        ((Validator)Mockito.verify((Object)validator)).validate((Object)expectedValue);
    }

    @Test
    void shouldInterpretMultipleOptionValues() {
        List<Integer> expectedValues = Arrays.asList(12, 34, 56);
        ArrayList<Object> argList = new ArrayList<Object>();
        String key = "number";
        Iterator iterator = expectedValues.iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            argList.add("--" + key);
            argList.add(String.valueOf(value));
        }
        Args args = Args.parse((String[])argList.toArray(new String[0]));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> args.get(key));
        Collection numbers = args.interpretOptions(key, k -> null, Integer::parseInt, new Validator[0]);
        org.junit.jupiter.api.Assertions.assertEquals(expectedValues, (Object)numbers);
    }

    @Test
    void testBooleanWithDefault() {
        Args args = Args.parse((String[])new String[]{"--no_value"});
        Assertions.assertThat((Boolean)args.getBoolean("not_set", Boolean.valueOf(true), Boolean.valueOf(true))).isTrue();
        Assertions.assertThat((Boolean)args.getBoolean("not_set", Boolean.valueOf(false), Boolean.valueOf(true))).isFalse();
        Assertions.assertThat((Boolean)args.getBoolean("not_set", Boolean.valueOf(false), Boolean.valueOf(false))).isFalse();
        Assertions.assertThat((Boolean)args.getBoolean("not_set", Boolean.valueOf(true), Boolean.valueOf(false))).isTrue();
        Assertions.assertThat((Boolean)args.getBoolean("no_value", Boolean.valueOf(true), Boolean.valueOf(true))).isTrue();
        Assertions.assertThat((Boolean)args.getBoolean("no_value", Boolean.valueOf(false), Boolean.valueOf(true))).isTrue();
        Assertions.assertThat((Boolean)args.getBoolean("no_value", Boolean.valueOf(false), Boolean.valueOf(false))).isFalse();
        Assertions.assertThat((Boolean)args.getBoolean("no_value", Boolean.valueOf(true), Boolean.valueOf(false))).isFalse();
    }

    @Test
    void shouldGetAsMap() {
        Args args = Args.parse((String[])new String[]{"--with-value", "value", "--without-value"});
        Map map = args.asMap();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)map).hasSize(2)).containsEntry((Object)"with-value", (Object)"value")).containsEntry((Object)"without-value", null);
    }

    @Test
    void shouldInterpretOptionMetadata() {
        Args args = Args.parse((String[])new String[]{"--my-option:Meta", "my value", "--my-option:Other", "other value"});
        Collection options = args.interpretOptionsWithMetadata("my-option", key -> {
            throw new IllegalArgumentException("Missing argument '" + key + "'");
        }, value -> value, new Validator[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)options.size());
        Iterator optionIterator = options.iterator();
        Args.Option first = (Args.Option)optionIterator.next();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"my value", (Object)first.value());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Meta", (Object)first.metadata());
        Args.Option second = (Args.Option)optionIterator.next();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"other value", (Object)second.value());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Other", (Object)second.metadata());
    }

    @Test
    void shouldHandleLastOrphanParam() {
        Args args = Args.withFlags((String[])new String[]{"recovery"}).parse(new String[]{"--recovery", "/tmp/neo4j"});
        List orphans = args.orphans();
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("/tmp/neo4j"), (Object)orphans);
    }

    @Test
    void shouldHandleOnlyFlagsAndNoArgs() {
        Args args = Args.withFlags((String[])new String[]{"foo", "bar"}).parse(new String[]{"-foo", "--bar"});
        List orphans = args.orphans();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), (Object)orphans);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)args.getBoolean("foo", Boolean.valueOf(false), Boolean.valueOf(true)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)args.getBoolean("bar", Boolean.valueOf(false), Boolean.valueOf(true)));
    }

    @Test
    void shouldStillAllowExplicitValuesForFlags() {
        Args args = Args.withFlags((String[])new String[]{"foo", "bar"}).parse(new String[]{"-foo=false", "--bar"});
        List orphans = args.orphans();
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(new String[0]), (Object)orphans);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)args.getBoolean("foo", Boolean.valueOf(false), Boolean.valueOf(false)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)args.getBoolean("bar", Boolean.valueOf(false), Boolean.valueOf(true)));
    }

    @Test
    void shouldHandleMixtureOfFlagsAndOrphanParams() {
        Args args = Args.withFlags((String[])new String[]{"big", "soft", "saysMeow"}).parse(new String[]{"-big", "-size=120", "-soft=true", "withStripes", "-saysMeow=false", "-name=ShereKhan", "badTiger"});
        List orphans = args.orphans();
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("withStripes", "badTiger"), (Object)orphans);
        org.junit.jupiter.api.Assertions.assertEquals((int)120, (int)args.getNumber("size", (Number)0).intValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ShereKhan", (Object)args.get("name"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)args.getBoolean("big", Boolean.valueOf(false), Boolean.valueOf(true)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)args.getBoolean("soft", Boolean.valueOf(false), Boolean.valueOf(false)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)args.getBoolean("saysMeow", Boolean.valueOf(true), Boolean.valueOf(true)));
    }

    @Test
    void shouldHandleFlagSpecifiedAsLastArgument() {
        Args args = Args.withFlags((String[])new String[]{"flag1", "flag2"}).parse(new String[]{"-key=Foo", "-flag1", "false", "-value", "Bar", "-flag2", "false"});
        List orphans = args.orphans();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)orphans.isEmpty(), (String)("Orphan args expected to be empty, but were: " + String.valueOf(orphans)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Foo", (Object)args.get("key"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Bar", (Object)args.get("value"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)args.getBoolean("flag1", Boolean.valueOf(true)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)args.getBoolean("flag2", Boolean.valueOf(true)));
    }

    @Test
    void shouldRecognizeFlagsOfAnyForm() {
        Args args = Args.withFlags((String[])new String[]{"flag1", "flag2", "flag3"}).parse(new String[]{"-key1=Foo", "-flag1", "-key1", "Bar", "-flag2=true", "-key3=Baz", "-flag3", "true"});
        List orphans = args.orphans();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)orphans.isEmpty(), (String)("Orphan args expected to be empty, but were: " + String.valueOf(orphans)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)args.getBoolean("flag1", Boolean.valueOf(false), Boolean.valueOf(true)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)args.getBoolean("flag2", Boolean.valueOf(false), Boolean.valueOf(false)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)args.getBoolean("flag3", Boolean.valueOf(false), Boolean.valueOf(false)));
    }

    @Test
    void shouldReturnEmptyCollectionForOptionalMissingOption() {
        Args args = Args.withFlags((String[])new String[0]).parse(new String[0]);
        Collection interpreted = args.interpretOptions("something", x -> null, value -> value, new Validator[0]);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)interpreted.isEmpty());
    }

    private static enum MyEnum {
        first,
        second,
        third;

    }
}

