/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.progress;

import java.io.OutputStream;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.mutable.MutableLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;

class ProgressMonitorFactoryTest {
    ProgressMonitorFactoryTest() {
    }

    @Test
    void shouldMapOneProgressRangeToAnother() {
        final MutableLong targetProgression = new MutableLong();
        ProgressListener.Adapter target = new ProgressListener.Adapter(this){

            public void add(long progress) {
                targetProgression.add(progress);
            }
        };
        int mappedResolution = 10;
        ProgressMonitorFactory factory = ProgressMonitorFactory.mapped((ProgressListener)target, (int)mappedResolution);
        int totalCount = 100;
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        try (ProgressListener source = factory.singlePart("Mapped", (long)totalCount);){
            int stride;
            for (int i = 0; i < totalCount; i += stride) {
                stride = rng.nextInt(1, 5);
                source.add((long)stride);
            }
        }
        Assertions.assertThat((long)targetProgression.longValue()).isEqualTo((long)mappedResolution);
    }

    @Test
    void shouldMapSubProgressesWithFractionsToAnother() {
        final MutableLong targetProgression = new MutableLong();
        final int totalResolution = 1000;
        ProgressListener.Adapter target = new ProgressListener.Adapter(this){

            public void add(long progress) {
                targetProgression.add(progress);
            }

            public int reportResolution() {
                return totalResolution;
            }
        };
        this.progressThrough(ProgressMonitorFactory.mappedFraction((ProgressListener)target, (float)0.1f).singlePart("first", 1234L));
        long progressionAfterFirst = targetProgression.longValue();
        this.progressThrough(ProgressMonitorFactory.mappedFraction((ProgressListener)target, (float)0.5f).singlePart("second", 34783L));
        long progressionAfterSecond = targetProgression.longValue();
        this.progressThrough(ProgressMonitorFactory.mappedFraction((ProgressListener)target, (float)0.4f).singlePart("third", 289L));
        long progressionAfterThird = targetProgression.longValue();
        Assertions.assertThat((long)progressionAfterFirst).isEqualTo(100L);
        Assertions.assertThat((long)progressionAfterSecond).isEqualTo(600L);
        Assertions.assertThat((long)progressionAfterThird).isEqualTo((long)totalResolution);
    }

    @Test
    void shouldCallIndicatorListenerSinglePart() {
        ProgressMonitorFactory factory = ProgressMonitorFactory.textual((OutputStream)OutputStream.nullOutputStream(), (boolean)false, (int)10, (int)1, (int)10);
        int total = 10000;
        ExternalListener listener = new ExternalListener(total);
        try (ProgressListener progress = factory.singlePart("Test indicator listener", (long)total, (ProgressMonitorFactory.IndicatorListener)listener);){
            for (int i = 0; i < total; ++i) {
                progress.add(1L);
            }
        }
        Assertions.assertThat((long)listener.seenProgress).isEqualTo((long)total);
    }

    @Test
    void shouldCallIndicatorListenerMultiPart() {
        ProgressMonitorFactory factory = ProgressMonitorFactory.textual((OutputStream)OutputStream.nullOutputStream(), (boolean)false, (int)10, (int)1, (int)10);
        int total = 10000;
        ExternalListener listener = new ExternalListener(total);
        ProgressMonitorFactory.MultiPartBuilder builder = factory.multipleParts("Test indicator listener", (ProgressMonitorFactory.IndicatorListener)listener);
        int part1Total = total / 4;
        int part2Total = total - part1Total;
        ProgressListener part1 = builder.progressForPart("Part 1", (long)part1Total);
        ProgressListener part2 = builder.progressForPart("Part 2", (long)part2Total);
        try (ProgressMonitorFactory.Completer completor = builder.build();
             ProgressListener progressListener = part2;
             ProgressListener progressListener2 = part1;){
            int i;
            for (i = 0; i < part1Total; ++i) {
                part1.add(1L);
            }
            for (i = 0; i < part2Total; ++i) {
                part2.add(1L);
            }
        }
        Assertions.assertThat((long)listener.seenProgress).isEqualTo((long)total);
    }

    private void progressThrough(ProgressListener listener) {
        try (ProgressListener progressListener = listener;){
            for (int i = 0; i < 10; ++i) {
                listener.add(1L);
            }
        }
    }

    private static class ExternalListener
    implements ProgressMonitorFactory.IndicatorListener {
        private final long total;
        private long seenProgress;

        ExternalListener(long total) {
            this.total = total;
        }

        public void update(long progress, long total) {
            Assertions.assertThat((long)progress).isGreaterThanOrEqualTo(this.seenProgress);
            Assertions.assertThat((long)total).isEqualTo(this.total);
            this.seenProgress = progress;
        }
    }
}

