/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.string;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.string.Mask;

class MaskTest {
    MaskTest() {
    }

    @Test
    void testFilter() {
        Assertions.assertThat((String)Mask.NO.filter((Object)"hello")).isEqualTo("hello");
        Assertions.assertThat((String)Mask.YES.filter((Object)"hello")).isEqualTo("<MASKED>");
    }

    @Test
    void testBuild() {
        StringBuilder builder = new StringBuilder();
        Mask.NO.build(builder, b -> b.append("hello"));
        Assertions.assertThat((StringBuilder)builder).hasToString("hello");
        builder = new StringBuilder();
        Mask.YES.build(builder, b -> b.append("hello"));
        Assertions.assertThat((StringBuilder)builder).hasToString("<MASKED>");
    }

    @Test
    void testFilterIterable() {
        List<MaskableThing> list = List.of(new MaskableThing("hello"), new MaskableThing("goodbye"));
        Assertions.assertThat((String)Mask.NO.filter(list)).isEqualTo("[data:hello, data:goodbye]");
        Assertions.assertThat((String)Mask.YES.filter(list)).isEqualTo("[data:<MASKED>, data:<MASKED>]");
    }

    @Test
    void testAppendIterable() {
        List<MaskableThing> list = List.of(new MaskableThing("hello"), new MaskableThing("goodbye"));
        StringBuilder builder = new StringBuilder();
        Mask.NO.append(builder, list);
        Assertions.assertThat((StringBuilder)builder).hasToString("[data:hello, data:goodbye]");
        builder = new StringBuilder();
        Mask.YES.append(builder, list);
        Assertions.assertThat((StringBuilder)builder).hasToString("[data:<MASKED>, data:<MASKED>]");
    }

    private record MaskableThing(String secret) implements Mask.Maskable
    {
        public String toString(Mask mask) {
            return "data:" + mask.filter((Object)this.secret);
        }
    }
}

