/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.kernel.lifecycle.Lifecycle;

public interface JobScheduler
extends Lifecycle {
    public Executor executor(Group var1);

    public ThreadFactory threadFactory(Group var1);

    public JobHandle schedule(Group var1, Runnable var2);

    public JobHandle schedule(Group var1, Runnable var2, Map<String, String> var3);

    public JobHandle schedule(Group var1, Runnable var2, long var3, TimeUnit var5);

    public JobHandle scheduleRecurring(Group var1, Runnable var2, long var3, TimeUnit var5);

    public JobHandle scheduleRecurring(Group var1, Runnable var2, long var3, long var5, TimeUnit var7);

    public static interface CancelListener {
        public void cancelled(boolean var1);
    }

    public static interface JobHandle {
        public void cancel(boolean var1);

        public void waitTermination() throws InterruptedException, ExecutionException;

        default public void registerCancelListener(CancelListener listener) {
            throw new UnsupportedOperationException("Unsupported in this implementation");
        }
    }

    public static class Groups {
        public static final Group sessionWorker = new Group("Session");
        public static final Group indexPopulation = new Group("IndexPopulation");
        public static final Group masterTransactionPushing = new Group("TransactionPushing");
        public static final Group serverTransactionTimeout = new Group("ServerTransactionTimeout");
        public static final Group slaveLocksTimeout = new Group("SlaveLocksTimeout");
        public static final Group pullUpdates = new Group("PullUpdates");
        public static final Group indexSamplingController = new Group("IndexSamplingController");
        public static final Group indexSampling = new Group("IndexSampling");
        public static final Group internalLogRotation = new Group("InternalLogRotation");
        public static final Group queryLogRotation = new Group("queryLogRotation");
        public static final Group boltLogRotation = new Group("BoltLogRotation");
        public static final Group checkPoint = new Group("CheckPoint");
        public static final Group raftLogPruning = new Group("RaftLogPruning");
        public static final Group boltNetworkIO = new Group("BoltNetworkIO");
        public static final Group metricsEvent = new Group("MetricsEvent");
        public static Group udc = new Group("UsageDataCollection");
        public static Group storageMaintenance = new Group("StorageMaintenance");
        public static Group nativeSecurity = new Group("NativeSecurity");
        public static Group fileWatch = new Group("FileWatcher");
        public static Group recoveryCleanup = new Group("RecoveryCleanup");
        public static Group transactionTimeoutMonitor = new Group("TransactionTimeoutMonitor");

        private Groups() {
        }
    }

    public static class Group {
        public static final String THREAD_ID = "thread-id";
        public static final Map<String, String> NO_METADATA = Collections.emptyMap();
        private final AtomicInteger threadCounter = new AtomicInteger();
        private final String name;

        public Group(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public String threadName(Map<String, String> metadata) {
            if (metadata.containsKey(THREAD_ID)) {
                return "neo4j." + this.name() + "-" + metadata.get(THREAD_ID);
            }
            return "neo4j." + this.name() + "-" + this.threadCounter.incrementAndGet();
        }
    }
}

