/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.lifecycle;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.lifecycle.LifecycleStatus;

public class LifeSupportTest {
    @Test
    public void testOkLifecycle() throws LifecycleException {
        LifeSupport lifeSupport = this.newLifeSupport();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance1);
        LifecycleMock instance2 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance3);
        lifeSupport.init();
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
        lifeSupport.start();
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance3.getStatus());
        lifeSupport.stop();
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
        lifeSupport.start();
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance3.getStatus());
        lifeSupport.shutdown();
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance3.getStatus());
    }

    @Test
    public void testFailingInit() {
        LifeSupport lifeSupport = this.newLifeSupport();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance1);
        Exception initThrowable = new Exception();
        LifecycleMock instance2 = new LifecycleMock(initThrowable, null, null, null);
        lifeSupport.add((Lifecycle)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance3);
        try {
            lifeSupport.init();
            Assert.fail();
        }
        catch (LifecycleException throwable) {
            Assert.assertEquals((Object)initThrowable, (Object)throwable.getCause());
        }
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.NONE, (Object)instance3.getStatus());
    }

    @Test
    public void testFailingStart() {
        LifeSupport lifeSupport = this.newLifeSupport();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance1);
        Exception startThrowable = new Exception();
        LifecycleMock instance2 = new LifecycleMock(null, startThrowable, null, null);
        lifeSupport.add((Lifecycle)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance3);
        try {
            lifeSupport.start();
            Assert.fail();
        }
        catch (LifecycleException throwable) {
            Assert.assertEquals((Object)startThrowable, (Object)throwable.getCause());
        }
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
    }

    @Test
    public void testFailingStartAndFailingStop() {
        LifeSupport lifeSupport = this.newLifeSupport();
        Exception stopThrowable = new Exception();
        LifecycleMock instance1 = new LifecycleMock(null, null, stopThrowable, null);
        lifeSupport.add((Lifecycle)instance1);
        Exception startThrowable = new Exception();
        LifecycleMock instance2 = new LifecycleMock(null, startThrowable, null, null);
        lifeSupport.add((Lifecycle)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance3);
        try {
            lifeSupport.start();
            Assert.fail();
        }
        catch (LifecycleException throwable) {
            Assert.assertEquals((Object)startThrowable, (Object)throwable.getCause());
            Assert.assertEquals((long)1L, (long)throwable.getSuppressed().length);
            Assert.assertThat((Object)throwable.getSuppressed()[0], (Matcher)Matchers.instanceOf(LifecycleException.class));
            Assert.assertEquals((Object)stopThrowable, (Object)throwable.getSuppressed()[0].getCause());
        }
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
    }

    @Test
    public void testFailingStop() throws LifecycleException {
        LifeSupport lifeSupport = this.newLifeSupport();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance1);
        Exception stopThrowable = new Exception();
        LifecycleMock instance2 = new LifecycleMock(null, null, stopThrowable, null);
        lifeSupport.add((Lifecycle)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance3);
        lifeSupport.start();
        try {
            lifeSupport.stop();
            Assert.fail();
        }
        catch (LifecycleException throwable) {
            Assert.assertEquals((Object)stopThrowable, (Object)throwable.getCause());
        }
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
    }

    @Test
    public void testFailingShutdown() throws LifecycleException {
        LifeSupport lifeSupport = this.newLifeSupport();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance1);
        Exception shutdownThrowable = new Exception();
        LifecycleMock instance2 = new LifecycleMock(null, null, null, shutdownThrowable);
        lifeSupport.add((Lifecycle)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance3);
        lifeSupport.start();
        try {
            lifeSupport.shutdown();
            Assert.fail();
        }
        catch (LifecycleException throwable) {
            Assert.assertEquals((Object)shutdownThrowable, (Object)throwable.getCause());
        }
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)lifeSupport.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance2.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance3.getStatus());
    }

    @Test
    public void testAddInstanceWhenInitInitsInstance() throws LifecycleException {
        LifeSupport support = this.newLifeSupport();
        support.init();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        support.add((Lifecycle)instance1);
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.NONE, (Object)instance1.transitions.get(0));
        Assert.assertEquals((long)2L, (long)instance1.transitions.size());
    }

    @Test
    public void testAddInstanceWhenStartedStartsInstance() throws LifecycleException {
        LifeSupport support = this.newLifeSupport();
        support.init();
        support.start();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        support.add((Lifecycle)instance1);
        Assert.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.NONE, (Object)instance1.transitions.get(0));
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.transitions.get(1));
        Assert.assertEquals((long)3L, (long)instance1.transitions.size());
    }

    @Test
    public void testAddInstanceWhenStoppedInitsInstance() throws LifecycleException {
        LifeSupport support = this.newLifeSupport();
        support.init();
        support.start();
        support.stop();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        support.add((Lifecycle)instance1);
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        Assert.assertEquals((Object)LifecycleStatus.NONE, (Object)instance1.transitions.get(0));
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.transitions.get(1));
        Assert.assertEquals((long)2L, (long)instance1.transitions.size());
    }

    @Test
    public void testAddInstanceWhenShutdownDoesNotAffectInstance() throws LifecycleException {
        LifeSupport support = this.newLifeSupport();
        support.init();
        support.start();
        support.stop();
        support.shutdown();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        support.add((Lifecycle)instance1);
        Assert.assertEquals((Object)LifecycleStatus.NONE, (Object)instance1.getStatus());
        Assert.assertEquals((long)1L, (long)instance1.transitions.size());
    }

    @Test
    public void testInitFailsShutdownWorks() throws Throwable {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle lifecycle = (Lifecycle)Mockito.mock(Lifecycle.class);
        RuntimeException runtimeException = new RuntimeException();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{runtimeException}).when((Object)lifecycle)).init();
        lifeSupport.add(lifecycle);
        try {
            lifeSupport.init();
            Assert.fail((String)"Expected exception");
        }
        catch (LifecycleException e) {
            Assert.assertEquals((Object)runtimeException, (Object)e.getCause());
            Assert.assertEquals((long)0L, (long)e.getSuppressed().length);
        }
    }

    @Test
    public void testInitFailsShutdownFails() throws Throwable {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle lifecycle1 = (Lifecycle)Mockito.mock(Lifecycle.class);
        Lifecycle lifecycle2 = (Lifecycle)Mockito.mock(Lifecycle.class);
        RuntimeException initRuntimeException = new RuntimeException();
        RuntimeException shutdownRuntimeException = new RuntimeException();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{initRuntimeException}).when((Object)lifecycle2)).init();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{shutdownRuntimeException}).when((Object)lifecycle1)).shutdown();
        lifeSupport.add(lifecycle1);
        lifeSupport.add(lifecycle2);
        try {
            lifeSupport.init();
            Assert.fail((String)"Expected exception");
        }
        catch (LifecycleException e) {
            Assert.assertEquals((Object)initRuntimeException, (Object)e.getCause());
            Assert.assertEquals((long)1L, (long)e.getSuppressed().length);
            Assert.assertEquals((Object)shutdownRuntimeException, (Object)e.getSuppressed()[0].getCause());
            Assert.assertThat((Object)e.getSuppressed()[0], (Matcher)Matchers.instanceOf(LifecycleException.class));
        }
    }

    @Test
    public void testStartFailsStopWorks() throws Throwable {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle lifecycle = (Lifecycle)Mockito.mock(Lifecycle.class);
        RuntimeException runtimeException = new RuntimeException();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{runtimeException}).when((Object)lifecycle)).start();
        lifeSupport.add(lifecycle);
        try {
            lifeSupport.start();
            Assert.fail((String)"Expected exception");
        }
        catch (LifecycleException e) {
            Assert.assertEquals((Object)runtimeException, (Object)e.getCause());
            Assert.assertEquals((long)0L, (long)e.getSuppressed().length);
        }
    }

    @Test
    public void testStartFailsStopFails() throws Throwable {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle lifecycle1 = (Lifecycle)Mockito.mock(Lifecycle.class);
        Lifecycle lifecycle2 = (Lifecycle)Mockito.mock(Lifecycle.class);
        RuntimeException startRuntimeException = new RuntimeException();
        RuntimeException stopRuntimeException = new RuntimeException();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{startRuntimeException}).when((Object)lifecycle2)).start();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{stopRuntimeException}).when((Object)lifecycle1)).stop();
        lifeSupport.add(lifecycle1);
        lifeSupport.add(lifecycle2);
        try {
            lifeSupport.start();
            Assert.fail((String)"Expected exception");
        }
        catch (LifecycleException e) {
            Assert.assertEquals((Object)startRuntimeException, (Object)e.getCause());
            Assert.assertEquals((long)1L, (long)e.getSuppressed().length);
            Assert.assertEquals((Object)stopRuntimeException, (Object)e.getSuppressed()[0].getCause());
            Assert.assertThat((Object)e.getSuppressed()[0], (Matcher)Matchers.instanceOf(LifecycleException.class));
        }
    }

    @Test
    public void testStopFailsShutdownWorks() throws Throwable {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle lifecycle = (Lifecycle)Mockito.mock(Lifecycle.class);
        RuntimeException runtimeException = new RuntimeException();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{runtimeException}).when((Object)lifecycle)).stop();
        lifeSupport.add(lifecycle);
        lifeSupport.start();
        try {
            lifeSupport.stop();
            Assert.fail((String)"Expected exception");
        }
        catch (LifecycleException e) {
            Assert.assertEquals((Object)runtimeException, (Object)e.getCause());
            Assert.assertEquals((long)0L, (long)e.getSuppressed().length);
        }
    }

    @Test
    public void testStopFailsShutdownFails() throws Throwable {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle lifecycle1 = (Lifecycle)Mockito.mock(Lifecycle.class);
        Lifecycle lifecycle2 = (Lifecycle)Mockito.mock(Lifecycle.class);
        RuntimeException stopRuntimeException = new RuntimeException();
        RuntimeException shutdownRuntimeException = new RuntimeException();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{stopRuntimeException}).when((Object)lifecycle2)).stop();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{shutdownRuntimeException}).when((Object)lifecycle1)).shutdown();
        lifeSupport.add(lifecycle1);
        lifeSupport.add(lifecycle2);
        lifeSupport.start();
        try {
            lifeSupport.shutdown();
            Assert.fail((String)"Expected exception");
        }
        catch (LifecycleException e) {
            Assert.assertEquals((Object)stopRuntimeException, (Object)e.getCause());
            Assert.assertEquals((long)1L, (long)e.getSuppressed().length);
            Assert.assertEquals((Object)shutdownRuntimeException, (Object)e.getSuppressed()[0].getCause());
            Assert.assertThat((Object)e.getSuppressed()[0], (Matcher)Matchers.instanceOf(LifecycleException.class));
        }
    }

    @Test
    public void tryToStopComponentOnStartFailure() throws Throwable {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle component = (Lifecycle)Mockito.mock(Lifecycle.class);
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Start exceptions")}).when((Object)component)).start();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Stop exceptions")}).when((Object)component)).stop();
        lifeSupport.add(component);
        try {
            lifeSupport.start();
            Assert.fail();
        }
        catch (Exception e) {
            String message = this.getExceptionStackTrace(e);
            Assert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"Exception during graceful attempt to stop partially started component. Please use non suppressed exception to see original component failure."));
        }
        Assert.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        ((Lifecycle)Mockito.verify((Object)component)).stop();
    }

    @Test
    public void tryToShutdownComponentOnInitFailure() throws Throwable {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle component = (Lifecycle)Mockito.mock(Lifecycle.class);
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Init exceptions")}).when((Object)component)).init();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Shutdown exceptions")}).when((Object)component)).shutdown();
        lifeSupport.add(component);
        try {
            lifeSupport.init();
            Assert.fail();
        }
        catch (Exception e) {
            String message = this.getExceptionStackTrace(e);
            Assert.assertThat((Object)message, (Matcher)Matchers.containsString((String)"Exception during graceful attempt to shutdown partially initialized component. Please use non suppressed exception to see original component failure."));
        }
        Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)lifeSupport.getStatus());
        ((Lifecycle)Mockito.verify((Object)component)).shutdown();
    }

    private LifeSupport newLifeSupport() {
        return new LifeSupport();
    }

    private String getExceptionStackTrace(Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static class LifecycleMock
    implements Lifecycle {
        Throwable initThrowable;
        Throwable startThrowable;
        Throwable stopThrowable;
        Throwable shutdownThrowable;
        List<LifecycleStatus> transitions;

        LifecycleMock(Throwable initThrowable, Throwable startThrowable, Throwable stopThrowable, Throwable shutdownThrowable) {
            this.initThrowable = initThrowable;
            this.startThrowable = startThrowable;
            this.stopThrowable = stopThrowable;
            this.shutdownThrowable = shutdownThrowable;
            this.transitions = new ArrayList<LifecycleStatus>();
            this.transitions.add(LifecycleStatus.NONE);
        }

        public void init() throws Throwable {
            if (this.initThrowable != null) {
                throw this.initThrowable;
            }
            this.transitions.add(LifecycleStatus.STOPPED);
        }

        public void start() throws Throwable {
            if (this.startThrowable != null) {
                throw this.startThrowable;
            }
            this.transitions.add(LifecycleStatus.STARTED);
        }

        public void stop() throws Throwable {
            this.transitions.add(LifecycleStatus.STOPPED);
            if (this.stopThrowable != null) {
                throw this.stopThrowable;
            }
        }

        public void shutdown() throws Throwable {
            this.transitions.add(LifecycleStatus.SHUTDOWN);
            if (this.shutdownThrowable != null) {
                throw this.shutdownThrowable;
            }
        }

        public LifecycleStatus getStatus() {
            return this.transitions.get(this.transitions.size() - 1);
        }
    }
}

