/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RepeatRule
implements TestRule {
    private final boolean printRepeats;
    private final int defaultTimes;
    private int count;

    public RepeatRule() {
        this(false, 1);
    }

    public RepeatRule(boolean printRepeats, int defaultRepeats) {
        this.printRepeats = printRepeats;
        this.defaultTimes = defaultRepeats;
    }

    public Statement apply(Statement base, Description description) {
        Repeat repeat = (Repeat)description.getAnnotation(Repeat.class);
        if (repeat != null) {
            return new RepeatStatement(repeat.times(), base, description);
        }
        if (this.defaultTimes > 1) {
            return new RepeatStatement(this.defaultTimes, base, description);
        }
        return base;
    }

    public int getCount() {
        return this.count;
    }

    private class RepeatStatement
    extends Statement {
        private final int times;
        private final Statement statement;
        private final String testName;

        private RepeatStatement(int times, Statement statement, Description testDescription) {
            this.times = times;
            this.statement = statement;
            this.testName = testDescription.getDisplayName();
        }

        public void evaluate() throws Throwable {
            RepeatRule.this.count = 0;
            while (RepeatRule.this.count < this.times) {
                if (RepeatRule.this.printRepeats) {
                    System.out.println(this.testName + " iteration " + (RepeatRule.this.count + 1) + "/" + this.times);
                }
                this.statement.evaluate();
                RepeatRule.this.count++;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Repeat {
        public int times();
    }
}

