/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.resources;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.resources.SunManagementHeapAllocation;

public class SunManagementHeapAllocationTest {
    @Before
    public void onlyOnSupportedJvms() {
        Assume.assumeFalse((HeapAllocation.HEAP_ALLOCATION == HeapAllocation.NOT_AVAILABLE ? 1 : 0) != 0);
    }

    @Test
    public void shouldLoadHeapAllocation() {
        Assert.assertNotSame((Object)HeapAllocation.NOT_AVAILABLE, (Object)HeapAllocation.HEAP_ALLOCATION);
        Assert.assertThat((Object)HeapAllocation.HEAP_ALLOCATION, (Matcher)Matchers.instanceOf(SunManagementHeapAllocation.class));
    }

    @Test
    public void shouldMeasureAllocation() {
        long allocatedBytes = HeapAllocation.HEAP_ALLOCATION.allocatedBytes(Thread.currentThread());
        ArrayList<Object> objects = new ArrayList<Object>();
        for (int i = 0; i < 17; ++i) {
            objects.add(new Object());
        }
        Assert.assertThat((Object)allocatedBytes, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(HeapAllocation.HEAP_ALLOCATION.allocatedBytes(Thread.currentThread()))));
        Assert.assertEquals((long)17L, (long)objects.size());
    }
}

