/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.memory.GlobalMemoryTracker;

public class GlobalMemoryTrackerTest {
    @Test
    public void trackMemoryAllocations() {
        long initialUsedMemory = GlobalMemoryTracker.INSTANCE.usedDirectMemory();
        GlobalMemoryTracker.INSTANCE.allocated(10L);
        GlobalMemoryTracker.INSTANCE.allocated(20L);
        GlobalMemoryTracker.INSTANCE.allocated(40L);
        Assert.assertEquals((long)70L, (long)(GlobalMemoryTracker.INSTANCE.usedDirectMemory() - initialUsedMemory));
    }

    @Test
    public void trackMemoryDeallocations() {
        long initialUsedMemory = GlobalMemoryTracker.INSTANCE.usedDirectMemory();
        GlobalMemoryTracker.INSTANCE.allocated(100L);
        Assert.assertEquals((long)100L, (long)(GlobalMemoryTracker.INSTANCE.usedDirectMemory() - initialUsedMemory));
        GlobalMemoryTracker.INSTANCE.deallocated(20L);
        Assert.assertEquals((long)80L, (long)(GlobalMemoryTracker.INSTANCE.usedDirectMemory() - initialUsedMemory));
        GlobalMemoryTracker.INSTANCE.deallocated(40L);
        Assert.assertEquals((long)40L, (long)(GlobalMemoryTracker.INSTANCE.usedDirectMemory() - initialUsedMemory));
    }
}

