/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.helpers.TextUtil;

class TextUtilTest {
    TextUtilTest() {
    }

    @Test
    void shouldReplaceVariablesWithValuesInTemplateString() {
        String template = "This is a $FIRST that $SECOND $THIRD!";
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("FIRST", "String");
        values.put("SECOND", "should");
        values.put("THIRD", "act as a template!");
        String string = TextUtil.templateString((String)template, values);
        Assertions.assertEquals((Object)"This is a String that should act as a template!!", (Object)string);
    }

    @Test
    void shouldTokenizeStringWithWithoutQuotes() {
        String untokenized = "First Second Third";
        Object[] tokenized = TextUtil.tokenizeStringWithQuotes((String)untokenized);
        Assertions.assertArrayEquals((Object[])new String[]{"First", "Second", "Third"}, (Object[])tokenized);
    }

    @Test
    void shouldTokenizeStringWithQuotes() {
        String untokenized = "First \"Second one\" Third \"And a fourth\"";
        Object[] tokenized = TextUtil.tokenizeStringWithQuotes((String)untokenized);
        Assertions.assertArrayEquals((Object[])new String[]{"First", "Second one", "Third", "And a fourth"}, (Object[])tokenized);
    }

    @Test
    void shouldTokenStringWithWithQuotesAndEscapedSpaces() {
        String untokenized = "First \"Second one\" Third And\\ a\\ fourth";
        Object[] tokenized = TextUtil.tokenizeStringWithQuotes((String)untokenized);
        Assertions.assertArrayEquals((Object[])new String[]{"First", "Second one", "Third", "And a fourth"}, (Object[])tokenized);
    }

    @Test
    void shouldPreserveBackslashes() {
        String untokenized = "First C:\\a\\b\\c";
        Object[] tokenized = TextUtil.tokenizeStringWithQuotes((String)untokenized, (boolean)true, (boolean)true);
        Assertions.assertArrayEquals((Object[])new String[]{"First", "C:\\a\\b\\c"}, (Object[])tokenized);
    }

    @Test
    void preserveOnlyPathBackslashes() {
        String untokenized = "First C:\\a\\ r\\b\\c";
        Object[] tokenized = TextUtil.tokenizeStringWithQuotes((String)untokenized, (boolean)true, (boolean)true, (boolean)false);
        Assertions.assertArrayEquals((Object[])new String[]{"First", "C:\\a r\\b\\c"}, (Object[])tokenized);
    }
}

