/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.resources;

import com.sun.management.ThreadMXBean;
import org.neo4j.resources.HeapAllocation;

class SunManagementHeapAllocation
extends HeapAllocation {
    private final ThreadMXBean threadMXBean;

    static HeapAllocation load(java.lang.management.ThreadMXBean bean) {
        if (ThreadMXBean.class.isInstance(bean)) {
            return new SunManagementHeapAllocation((ThreadMXBean)bean);
        }
        return NOT_AVAILABLE;
    }

    private SunManagementHeapAllocation(ThreadMXBean threadMXBean) {
        this.threadMXBean = threadMXBean;
    }

    @Override
    public long allocatedBytes(long threadId) {
        if (!this.threadMXBean.isThreadAllocatedMemorySupported()) {
            return -1L;
        }
        if (!this.threadMXBean.isThreadAllocatedMemoryEnabled()) {
            this.threadMXBean.setThreadAllocatedMemoryEnabled(true);
        }
        return this.threadMXBean.getThreadAllocatedBytes(threadId);
    }
}

