/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.resources;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.resources.Profiler;

class ProfilerTest {
    private static final int COMPUTE_WORK_MILLIS = 1000;

    ProfilerTest() {
    }

    @Test
    void profilerMustNoticeWhereTimeGoes() throws Exception {
        Profiler profiler = Profiler.profiler();
        try (Profiler.ProfiledInterval ignored = profiler.profile();){
            this.expensiveComputation();
        }
        String output = this.getProfilerOutput(profiler);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"expensiveComputation"));
    }

    @Test
    void profilerMustLimitItselfToProfiledRegion() throws Exception {
        Profiler profiler = Profiler.profiler();
        try (Profiler.ProfiledInterval ignored = profiler.profile();){
            this.expensiveComputation();
        }
        this.otherIntenseWork();
        String output = this.getProfilerOutput(profiler);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"otherIntensiveWork")));
    }

    @Test
    void profilerMustWaitUntilAfterAnInitialDelay() throws Exception {
        Profiler profiler = Profiler.profiler();
        long initialDelayNanos = TimeUnit.MILLISECONDS.toNanos(3000L);
        try (Profiler.ProfiledInterval ignored = profiler.profile(Thread.currentThread(), initialDelayNanos);){
            this.expensiveComputation();
        }
        String output = this.getProfilerOutput(profiler);
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"expensiveComputation")));
    }

    private String getProfilerOutput(Profiler profiler) throws InterruptedException {
        profiler.finish();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try (PrintStream out = new PrintStream(buffer);){
            profiler.printProfile(out, "Profile");
            out.flush();
        }
        return buffer.toString();
    }

    private void expensiveComputation() throws InterruptedException {
        Thread.sleep(1000L);
    }

    private void otherIntenseWork() throws InterruptedException {
        Thread.sleep(1000L);
    }
}

