/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class DaemonThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final AtomicInteger counter = new AtomicInteger();

    public DaemonThreadFactory() {
        this("DaemonThread");
    }

    public DaemonThreadFactory(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        ThreadFactory factory = Executors.defaultThreadFactory();
        Thread thread = factory.newThread(runnable);
        thread.setDaemon(true);
        thread.setName(this.prefix + this.counter.getAndIncrement());
        return thread;
    }
}

