/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.memory.MemoryAllocationTracker;

public class ThreadSafePeakMemoryAllocationTracker
implements MemoryAllocationTracker {
    private final AtomicLong allocated = new AtomicLong();
    private final AtomicLong peak = new AtomicLong();
    private final MemoryAllocationTracker alsoReportTo;

    public ThreadSafePeakMemoryAllocationTracker(MemoryAllocationTracker alsoReportTo) {
        this.alsoReportTo = alsoReportTo;
    }

    @Override
    public void allocated(long bytes) {
        long updatedPeak;
        long currentPeak;
        long total = this.allocated.addAndGet(bytes);
        while ((currentPeak = this.peak.get()) < total && !this.peak.compareAndSet(currentPeak, updatedPeak = Long.max(currentPeak, total))) {
        }
        this.alsoReportTo.allocated(bytes);
    }

    @Override
    public void deallocated(long bytes) {
        this.allocated.addAndGet(-bytes);
        this.alsoReportTo.deallocated(bytes);
    }

    @Override
    public long usedDirectMemory() {
        return this.allocated.get();
    }

    public long peakMemoryUsage() {
        return this.peak.get();
    }
}

