/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.matchers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.helpers.Exceptions;
import org.neo4j.test.matchers.ExceptionMessageMatcher;

public final class CommonMatchers {
    private CommonMatchers() {
    }

    @SafeVarargs
    public static <T> Matcher<? super Iterable<T>> matchesOneToOneInAnyOrder(Matcher<? super T> ... expectedMatchers) {
        return new MatchesOneToOneInAnyOrder<T>(expectedMatchers);
    }

    public static Matcher<Throwable> matchesExceptionMessage(Matcher<? super String> matcher) {
        return new ExceptionMessageMatcher(matcher);
    }

    public static Matcher<Throwable> hasSuppressed(final Throwable ... expectedSuppressedErrors) {
        return new TypeSafeMatcher<Throwable>(){

            protected boolean matchesSafely(Throwable item) {
                return Arrays.equals(item.getSuppressed(), expectedSuppressedErrors);
            }

            public void describeTo(Description description) {
                description.appendText("a throwable with suppressed:\n");
                if (expectedSuppressedErrors.length == 0) {
                    description.appendText("a throwable without suppressed");
                } else {
                    description.appendText("a throwable with suppressed:\n");
                    String expectedSuppressedAsString = Arrays.stream(expectedSuppressedErrors).map(Exceptions::stringify).collect(Collectors.joining("\n", "[\n", "]"));
                    description.appendText(expectedSuppressedAsString);
                }
            }
        };
    }

    private static class MatchesOneToOneInAnyOrder<T>
    extends TypeSafeMatcher<Iterable<T>> {
        private final Matcher<? super T>[] expectedMatchers;

        @SafeVarargs
        MatchesOneToOneInAnyOrder(Matcher<? super T> ... expectedMatchers) {
            this.expectedMatchers = expectedMatchers;
        }

        protected boolean matchesSafely(Iterable<T> items) {
            Set<Matcher<T>> matchers = this.uniqueMatchers();
            for (T item : items) {
                Matcher<T> matcherFound = null;
                for (Matcher<T> matcherConsidered : matchers) {
                    if (!matcherConsidered.matches(item)) continue;
                    if (matcherFound == null) {
                        matcherFound = matcherConsidered;
                        continue;
                    }
                    return false;
                }
                if (matcherFound == null) {
                    return false;
                }
                matchers.remove(matcherFound);
            }
            return matchers.isEmpty();
        }

        public void describeTo(Description description) {
            Set<Matcher<T>> matchers = this.uniqueMatchers();
            description.appendText("items that each match exactly one of ");
            description.appendList("{ ", ", ", " }", matchers);
            description.appendText(" and exactly as many items as matchers");
        }

        private Set<Matcher<? super T>> uniqueMatchers() {
            HashSet<Matcher<? super T>> matchers = new HashSet<Matcher<? super T>>();
            Collections.addAll(matchers, this.expectedMatchers);
            return matchers;
        }
    }
}

