/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.time;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.neo4j.time.SystemNanoClock;

public class FakeClock
extends SystemNanoClock {
    private volatile long nanoTime;

    public FakeClock() {
    }

    public FakeClock(long initialTime, TimeUnit unit) {
        this.forward(initialTime, unit);
    }

    @Override
    public ZoneId getZone() {
        return ZoneOffset.UTC;
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return new WithZone(zone);
    }

    @Override
    public Instant instant() {
        return Instant.ofEpochMilli(TimeUnit.NANOSECONDS.toMillis(this.nanoTime));
    }

    @Override
    public long nanos() {
        return this.nanoTime;
    }

    @Override
    public long millis() {
        return TimeUnit.NANOSECONDS.toMillis(this.nanoTime);
    }

    public FakeClock forward(Duration delta) {
        return this.forward(delta.toNanos(), TimeUnit.NANOSECONDS);
    }

    public FakeClock forward(long delta, TimeUnit unit) {
        this.nanoTime += unit.toNanos(delta);
        return this;
    }

    private class WithZone
    extends Clock {
        private final ZoneId zone;

        WithZone(ZoneId zone) {
            this.zone = zone;
        }

        @Override
        public ZoneId getZone() {
            return this.zone;
        }

        @Override
        public Clock withZone(ZoneId zone) {
            return new WithZone(zone);
        }

        @Override
        public long millis() {
            return FakeClock.this.millis();
        }

        @Override
        public Instant instant() {
            return FakeClock.this.instant();
        }
    }
}

