/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ports.allocation;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.ports.allocation.PortProbe;
import org.neo4j.ports.allocation.SimplePortProvider;

class SimplePortProviderTest {
    SimplePortProviderTest() {
    }

    @Test
    void shouldProvideUniquePorts() {
        SimplePortProvider portProvider = new SimplePortProvider(port -> false, 42);
        int port1 = portProvider.getNextFreePort("foo");
        int port2 = portProvider.getNextFreePort("foo");
        MatcherAssert.assertThat((Object)port1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)port2))));
    }

    @Test
    void shouldSkipOccupiedPorts() {
        PortProbe portProbe = (PortProbe)Mockito.mock(PortProbe.class);
        SimplePortProvider portProvider = new SimplePortProvider(portProbe, 40);
        Mockito.when((Object)portProbe.isOccupied(40)).thenReturn((Object)false);
        Mockito.when((Object)portProbe.isOccupied(41)).thenReturn((Object)false);
        Mockito.when((Object)portProbe.isOccupied(42)).thenReturn((Object)true);
        Mockito.when((Object)portProbe.isOccupied(43)).thenReturn((Object)false);
        MatcherAssert.assertThat((Object)portProvider.getNextFreePort("foo"), (Matcher)CoreMatchers.is((Object)40));
        MatcherAssert.assertThat((Object)portProvider.getNextFreePort("foo"), (Matcher)CoreMatchers.is((Object)41));
        MatcherAssert.assertThat((Object)portProvider.getNextFreePort("foo"), (Matcher)CoreMatchers.is((Object)43));
    }

    @Test
    void shouldNotOverRun() {
        SimplePortProvider portProvider = new SimplePortProvider(port -> false, 65534);
        portProvider.getNextFreePort("foo");
        portProvider.getNextFreePort("foo");
        try {
            portProvider.getNextFreePort("foo");
            Assertions.fail((String)"Failure was expected");
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"There are no more ports available"));
        }
    }
}

