/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.ExponentialBackoffStrategy;
import org.neo4j.internal.helpers.TimeoutStrategy;

class ExponentialBackoffStrategyTest {
    private static final int NUMBER_OF_ACCESSES = 5;

    ExponentialBackoffStrategyTest() {
    }

    @Test
    void shouldDoubleEachTime() {
        ExponentialBackoffStrategy strategy = new ExponentialBackoffStrategy(1L, 32L, TimeUnit.MILLISECONDS);
        TimeoutStrategy.Timeout timeout = strategy.newTimeout();
        for (int i = 0; i < 5; ++i) {
            timeout.increment();
        }
        Assertions.assertEquals((long)32L, (long)timeout.getMillis());
    }

    @Test
    void shouldProvidePreviousTimeout() {
        ExponentialBackoffStrategy strategy = new ExponentialBackoffStrategy(1L, 32L, TimeUnit.MILLISECONDS);
        TimeoutStrategy.Timeout timeout = strategy.newTimeout();
        for (int i = 0; i < 5; ++i) {
            timeout.increment();
        }
        Assertions.assertEquals((long)32L, (long)timeout.getMillis());
    }

    @Test
    void shouldRespectUpperBound() {
        long upperBound = 27L;
        ExponentialBackoffStrategy strategy = new ExponentialBackoffStrategy(1L, upperBound, TimeUnit.MILLISECONDS);
        TimeoutStrategy.Timeout timeout = strategy.newTimeout();
        for (int i = 0; i < 5; ++i) {
            timeout.increment();
        }
        Assertions.assertEquals((long)upperBound, (long)timeout.getMillis());
        timeout.increment();
        timeout.increment();
        timeout.increment();
        Assertions.assertEquals((long)upperBound, (long)timeout.getMillis());
    }
}

