/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.Format;

class FormatTest {
    FormatTest() {
    }

    @Test
    void shouldDisplayPlainCount() {
        String format = Format.count((long)10L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.startsWith("10"));
    }

    @Test
    void shouldDisplayThousandCount() {
        String format = Format.count((long)2000L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.startsWith("2"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.endsWith("k"));
    }

    @Test
    void shouldDisplayMillionCount() {
        String format = Format.count((long)2000000L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.startsWith("2"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.endsWith("M"));
    }

    @Test
    void shouldDisplayBillionCount() {
        String format = Format.count((long)2000000000L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.startsWith("2"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.endsWith("G"));
    }

    @Test
    void shouldDisplayTrillionCount() {
        String format = Format.count((long)4000000000000L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.startsWith("4"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)format.endsWith("T"));
    }

    @Test
    void displayDuration() {
        Assertions.assertThat((String)Format.duration((long)(TimeUnit.MINUTES.toMillis(1L) + TimeUnit.SECONDS.toMillis(2L)))).isEqualTo("1m 2s");
        Assertions.assertThat((String)Format.duration((long)42L)).isEqualTo("42ms");
        Assertions.assertThat((String)Format.duration((long)0L)).isEqualTo("0ms");
    }
}

