/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.lifecycle;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.lifecycle.LifecycleStatus;

class LifeSupportTest {
    LifeSupportTest() {
    }

    @Test
    void testOkLifecycle() throws LifecycleException {
        LifeSupport lifeSupport = this.newLifeSupport();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance1);
        LifecycleMock instance2 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance3);
        lifeSupport.init();
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
        lifeSupport.start();
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STARTED, (Object)lifeSupport.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance1.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance2.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance3.getStatus());
        lifeSupport.stop();
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
        lifeSupport.start();
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STARTED, (Object)lifeSupport.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance1.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance2.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance3.getStatus());
        lifeSupport.shutdown();
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)lifeSupport.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance1.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance2.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance3.getStatus());
    }

    @Test
    void testFailingInit() {
        LifeSupport lifeSupport = this.newLifeSupport();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance1);
        Exception initThrowable = new Exception();
        LifecycleMock instance2 = new LifecycleMock(initThrowable, null, null, null);
        lifeSupport.add((Lifecycle)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance3);
        try {
            lifeSupport.init();
            org.junit.jupiter.api.Assertions.fail((String)"Failure was expected");
        }
        catch (LifecycleException throwable) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)initThrowable, (Object)throwable.getCause());
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)lifeSupport.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance1.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance2.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.NONE, (Object)instance3.getStatus());
    }

    @Test
    void testFailingStart() {
        LifeSupport lifeSupport = this.newLifeSupport();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance1);
        Exception startThrowable = new Exception();
        LifecycleMock instance2 = new LifecycleMock(null, startThrowable, null, null);
        lifeSupport.add((Lifecycle)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance3);
        try {
            lifeSupport.start();
            org.junit.jupiter.api.Assertions.fail((String)"Failure was expected");
        }
        catch (LifecycleException throwable) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)startThrowable, (Object)throwable.getCause());
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
    }

    @Test
    void testFailingStartAndFailingStop() {
        LifeSupport lifeSupport = this.newLifeSupport();
        Exception stopThrowable = new Exception();
        LifecycleMock instance1 = new LifecycleMock(null, null, stopThrowable, null);
        lifeSupport.add((Lifecycle)instance1);
        Exception startThrowable = new Exception();
        LifecycleMock instance2 = new LifecycleMock(null, startThrowable, null, null);
        lifeSupport.add((Lifecycle)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance3);
        try {
            lifeSupport.start();
            org.junit.jupiter.api.Assertions.fail((String)"Failure was expected");
        }
        catch (LifecycleException throwable) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)startThrowable, (Object)throwable.getCause());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)throwable.getSuppressed().length);
            Assertions.assertThat((Throwable)throwable.getSuppressed()[0]).isInstanceOf(LifecycleException.class);
            org.junit.jupiter.api.Assertions.assertEquals((Object)stopThrowable, (Object)throwable.getSuppressed()[0].getCause());
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
    }

    @Test
    void testFailingStop() throws LifecycleException {
        LifeSupport lifeSupport = this.newLifeSupport();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance1);
        Exception stopThrowable = new Exception();
        LifecycleMock instance2 = new LifecycleMock(null, null, stopThrowable, null);
        lifeSupport.add((Lifecycle)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance3);
        lifeSupport.start();
        try {
            lifeSupport.stop();
            org.junit.jupiter.api.Assertions.fail((String)"Failure was expected");
        }
        catch (LifecycleException throwable) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)stopThrowable, (Object)throwable.getCause());
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance2.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance3.getStatus());
    }

    @Test
    void testFailingShutdown() throws LifecycleException {
        LifeSupport lifeSupport = this.newLifeSupport();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance1);
        Exception shutdownThrowable = new Exception();
        LifecycleMock instance2 = new LifecycleMock(null, null, null, shutdownThrowable);
        lifeSupport.add((Lifecycle)instance2);
        LifecycleMock instance3 = new LifecycleMock(null, null, null, null);
        lifeSupport.add((Lifecycle)instance3);
        lifeSupport.start();
        try {
            lifeSupport.shutdown();
            org.junit.jupiter.api.Assertions.fail((String)"Failure was expected");
        }
        catch (LifecycleException throwable) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)shutdownThrowable, (Object)throwable.getCause());
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)lifeSupport.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance1.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance2.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)instance3.getStatus());
    }

    @Test
    void testAddInstanceWhenInitInitsInstance() throws LifecycleException {
        LifeSupport support = this.newLifeSupport();
        support.init();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        support.add((Lifecycle)instance1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.NONE, (Object)instance1.transitions.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)instance1.transitions.size());
    }

    @Test
    void testAddInstanceWhenStartedStartsInstance() throws LifecycleException {
        LifeSupport support = this.newLifeSupport();
        support.init();
        support.start();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        support.add((Lifecycle)instance1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STARTED, (Object)instance1.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.NONE, (Object)instance1.transitions.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.transitions.get(1));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)instance1.transitions.size());
    }

    @Test
    void testAddInstanceWhenStoppedInitsInstance() throws LifecycleException {
        LifeSupport support = this.newLifeSupport();
        support.init();
        support.start();
        support.stop();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        support.add((Lifecycle)instance1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.NONE, (Object)instance1.transitions.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)instance1.transitions.get(1));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)instance1.transitions.size());
    }

    @Test
    void testAddInstanceWhenShutdownDoesNotAffectInstance() throws LifecycleException {
        LifeSupport support = this.newLifeSupport();
        support.init();
        support.start();
        support.stop();
        support.shutdown();
        LifecycleMock instance1 = new LifecycleMock(null, null, null, null);
        support.add((Lifecycle)instance1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.NONE, (Object)instance1.getStatus());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)instance1.transitions.size());
    }

    @Test
    void testInitFailsShutdownWorks() throws Throwable {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle lifecycle = (Lifecycle)Mockito.mock(Lifecycle.class);
        RuntimeException runtimeException = new RuntimeException();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{runtimeException}).when((Object)lifecycle)).init();
        lifeSupport.add(lifecycle);
        try {
            lifeSupport.init();
            org.junit.jupiter.api.Assertions.fail((String)"Expected exception");
        }
        catch (LifecycleException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)runtimeException, (Object)e.getCause());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)e.getSuppressed().length);
        }
    }

    @Test
    void testInitFailsShutdownFails() throws Throwable {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle lifecycle1 = (Lifecycle)Mockito.mock(Lifecycle.class);
        Lifecycle lifecycle2 = (Lifecycle)Mockito.mock(Lifecycle.class);
        RuntimeException initRuntimeException = new RuntimeException();
        RuntimeException shutdownRuntimeException = new RuntimeException();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{initRuntimeException}).when((Object)lifecycle2)).init();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{shutdownRuntimeException}).when((Object)lifecycle1)).shutdown();
        lifeSupport.add(lifecycle1);
        lifeSupport.add(lifecycle2);
        try {
            lifeSupport.init();
            org.junit.jupiter.api.Assertions.fail((String)"Expected exception");
        }
        catch (LifecycleException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)initRuntimeException, (Object)e.getCause());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)e.getSuppressed().length);
            org.junit.jupiter.api.Assertions.assertEquals((Object)shutdownRuntimeException, (Object)e.getSuppressed()[0].getCause());
            Assertions.assertThat((Throwable)e.getSuppressed()[0]).isInstanceOf(LifecycleException.class);
        }
    }

    @Test
    void testStartFailsStopWorks() throws Throwable {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle lifecycle = (Lifecycle)Mockito.mock(Lifecycle.class);
        RuntimeException runtimeException = new RuntimeException();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{runtimeException}).when((Object)lifecycle)).start();
        lifeSupport.add(lifecycle);
        try {
            lifeSupport.start();
            org.junit.jupiter.api.Assertions.fail((String)"Expected exception");
        }
        catch (LifecycleException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)runtimeException, (Object)e.getCause());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)e.getSuppressed().length);
        }
    }

    @Test
    void testStartFailsStopFails() throws Throwable {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle lifecycle1 = (Lifecycle)Mockito.mock(Lifecycle.class);
        Lifecycle lifecycle2 = (Lifecycle)Mockito.mock(Lifecycle.class);
        RuntimeException startRuntimeException = new RuntimeException();
        RuntimeException stopRuntimeException = new RuntimeException();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{startRuntimeException}).when((Object)lifecycle2)).start();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{stopRuntimeException}).when((Object)lifecycle1)).stop();
        lifeSupport.add(lifecycle1);
        lifeSupport.add(lifecycle2);
        try {
            lifeSupport.start();
            org.junit.jupiter.api.Assertions.fail((String)"Expected exception");
        }
        catch (LifecycleException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)startRuntimeException, (Object)e.getCause());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)e.getSuppressed().length);
            org.junit.jupiter.api.Assertions.assertEquals((Object)stopRuntimeException, (Object)e.getSuppressed()[0].getCause());
            Assertions.assertThat((Throwable)e.getSuppressed()[0]).isInstanceOf(LifecycleException.class);
        }
    }

    @Test
    void testStopFailsShutdownWorks() throws Throwable {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle lifecycle = (Lifecycle)Mockito.mock(Lifecycle.class);
        RuntimeException runtimeException = new RuntimeException();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{runtimeException}).when((Object)lifecycle)).stop();
        lifeSupport.add(lifecycle);
        lifeSupport.start();
        try {
            lifeSupport.stop();
            org.junit.jupiter.api.Assertions.fail((String)"Expected exception");
        }
        catch (LifecycleException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)runtimeException, (Object)e.getCause());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)e.getSuppressed().length);
        }
    }

    @Test
    void testStopFailsShutdownFails() throws Throwable {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle lifecycle1 = (Lifecycle)Mockito.mock(Lifecycle.class);
        Lifecycle lifecycle2 = (Lifecycle)Mockito.mock(Lifecycle.class);
        RuntimeException stopRuntimeException = new RuntimeException();
        RuntimeException shutdownRuntimeException = new RuntimeException();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{stopRuntimeException}).when((Object)lifecycle2)).stop();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{shutdownRuntimeException}).when((Object)lifecycle1)).shutdown();
        lifeSupport.add(lifecycle1);
        lifeSupport.add(lifecycle2);
        lifeSupport.start();
        try {
            lifeSupport.shutdown();
            org.junit.jupiter.api.Assertions.fail((String)"Expected exception");
        }
        catch (LifecycleException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)stopRuntimeException, (Object)e.getCause());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)e.getSuppressed().length);
            org.junit.jupiter.api.Assertions.assertEquals((Object)shutdownRuntimeException, (Object)e.getSuppressed()[0].getCause());
            Assertions.assertThat((Throwable)e.getSuppressed()[0]).isInstanceOf(LifecycleException.class);
        }
    }

    @Test
    void tryToStopComponentOnStartFailure() throws Throwable {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle component = (Lifecycle)Mockito.mock(Lifecycle.class);
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Start exceptions")}).when((Object)component)).start();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Stop exceptions")}).when((Object)component)).stop();
        lifeSupport.add(component);
        try {
            lifeSupport.start();
            org.junit.jupiter.api.Assertions.fail((String)"Failure was expected");
        }
        catch (Exception e) {
            String message = this.getExceptionStackTrace(e);
            Assertions.assertThat((String)message).contains(new CharSequence[]{"Exception during graceful attempt to stop partially started component. Please use non suppressed exception to see original component failure."});
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.STOPPED, (Object)lifeSupport.getStatus());
        ((Lifecycle)Mockito.verify((Object)component)).stop();
    }

    @Test
    void tryToShutdownComponentOnInitFailure() throws Throwable {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle component = (Lifecycle)Mockito.mock(Lifecycle.class);
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Init exceptions")}).when((Object)component)).init();
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Shutdown exceptions")}).when((Object)component)).shutdown();
        lifeSupport.add(component);
        try {
            lifeSupport.init();
            org.junit.jupiter.api.Assertions.fail((String)"Failure was expected");
        }
        catch (Exception e) {
            String message = this.getExceptionStackTrace(e);
            Assertions.assertThat((String)message).contains(new CharSequence[]{"Exception during graceful attempt to shutdown partially initialized component. Please use non suppressed exception to see original component failure."});
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)lifeSupport.getStatus());
        ((Lifecycle)Mockito.verify((Object)component)).shutdown();
    }

    @Test
    void addLastComponentBeforeChain() {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle lastComponent = (Lifecycle)Mockito.mock(Lifecycle.class);
        Lifecycle notLastComponent1 = (Lifecycle)Mockito.mock(Lifecycle.class);
        Lifecycle notLastComponent2 = (Lifecycle)Mockito.mock(Lifecycle.class);
        Lifecycle notLastComponent3 = (Lifecycle)Mockito.mock(Lifecycle.class);
        Lifecycle notLastComponent4 = (Lifecycle)Mockito.mock(Lifecycle.class);
        lifeSupport.setLast(lastComponent);
        lifeSupport.add(notLastComponent1);
        lifeSupport.add(notLastComponent2);
        lifeSupport.add(notLastComponent3);
        lifeSupport.add(notLastComponent4);
        lifeSupport.start();
        List lifecycleInstances = lifeSupport.getLifecycleInstances();
        org.junit.jupiter.api.Assertions.assertSame((Object)notLastComponent1, lifecycleInstances.get(0));
        org.junit.jupiter.api.Assertions.assertSame((Object)notLastComponent2, lifecycleInstances.get(1));
        org.junit.jupiter.api.Assertions.assertSame((Object)notLastComponent3, lifecycleInstances.get(2));
        org.junit.jupiter.api.Assertions.assertSame((Object)notLastComponent4, lifecycleInstances.get(3));
        org.junit.jupiter.api.Assertions.assertSame((Object)lastComponent, lifecycleInstances.get(4));
        Assertions.assertThat((List)lifecycleInstances).hasSize(5);
    }

    @Test
    void addLastComponentSomewhereInAChain() {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle notLastComponent1 = (Lifecycle)Mockito.mock(Lifecycle.class);
        Lifecycle notLastComponent2 = (Lifecycle)Mockito.mock(Lifecycle.class);
        Lifecycle lastComponent = (Lifecycle)Mockito.mock(Lifecycle.class);
        Lifecycle notLastComponent3 = (Lifecycle)Mockito.mock(Lifecycle.class);
        Lifecycle notLastComponent4 = (Lifecycle)Mockito.mock(Lifecycle.class);
        lifeSupport.add(notLastComponent1);
        lifeSupport.add(notLastComponent2);
        lifeSupport.setLast(lastComponent);
        lifeSupport.add(notLastComponent3);
        lifeSupport.add(notLastComponent4);
        lifeSupport.start();
        List lifecycleInstances = lifeSupport.getLifecycleInstances();
        org.junit.jupiter.api.Assertions.assertSame((Object)notLastComponent1, lifecycleInstances.get(0));
        org.junit.jupiter.api.Assertions.assertSame((Object)notLastComponent2, lifecycleInstances.get(1));
        org.junit.jupiter.api.Assertions.assertSame((Object)notLastComponent3, lifecycleInstances.get(2));
        org.junit.jupiter.api.Assertions.assertSame((Object)notLastComponent4, lifecycleInstances.get(3));
        org.junit.jupiter.api.Assertions.assertSame((Object)lastComponent, lifecycleInstances.get(4));
        Assertions.assertThat((List)lifecycleInstances).hasSize(5);
    }

    @Test
    void addOnlyLastComponent() {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle lastComponent = (Lifecycle)Mockito.mock(Lifecycle.class);
        lifeSupport.setLast(lastComponent);
        lifeSupport.start();
        List lifecycleInstances = lifeSupport.getLifecycleInstances();
        org.junit.jupiter.api.Assertions.assertSame((Object)lastComponent, lifecycleInstances.get(0));
        Assertions.assertThat((List)lifecycleInstances).hasSize(1);
    }

    @Test
    void failToAddSeveralLastComponents() {
        LifeSupport lifeSupport = this.newLifeSupport();
        Lifecycle lastComponent = (Lifecycle)Mockito.mock(Lifecycle.class);
        Lifecycle anotherLastComponent = (Lifecycle)Mockito.mock(Lifecycle.class);
        lifeSupport.setLast(lastComponent);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> lifeSupport.setLast(anotherLastComponent));
    }

    private LifeSupport newLifeSupport() {
        return new LifeSupport();
    }

    private String getExceptionStackTrace(Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    static class LifecycleMock
    implements Lifecycle {
        Exception initException;
        Exception startException;
        Exception stopException;
        Exception shutdownException;
        List<LifecycleStatus> transitions;

        LifecycleMock(Exception initException, Exception startException, Exception stopException, Exception shutdownExeption) {
            this.initException = initException;
            this.startException = startException;
            this.stopException = stopException;
            this.shutdownException = shutdownExeption;
            this.transitions = new ArrayList<LifecycleStatus>();
            this.transitions.add(LifecycleStatus.NONE);
        }

        public void init() throws Exception {
            if (this.initException != null) {
                throw this.initException;
            }
            this.transitions.add(LifecycleStatus.STOPPED);
        }

        public void start() throws Exception {
            if (this.startException != null) {
                throw this.startException;
            }
            this.transitions.add(LifecycleStatus.STARTED);
        }

        public void stop() throws Exception {
            this.transitions.add(LifecycleStatus.STOPPED);
            if (this.stopException != null) {
                throw this.stopException;
            }
        }

        public void shutdown() throws Exception {
            this.transitions.add(LifecycleStatus.SHUTDOWN);
            if (this.shutdownException != null) {
                throw this.shutdownException;
            }
        }

        LifecycleStatus getStatus() {
            return this.transitions.get(this.transitions.size() - 1);
        }
    }
}

