/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.resources;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.resources.Profiler;

class ProfilerTest {
    private static final int COMPUTE_WORK_MILLIS = 10;
    private static final String METHOD = "expensiveComputation";

    ProfilerTest() {
    }

    @Test
    void profilerMustNoticeWhereTimeGoes() throws Exception {
        Profiler profiler = Profiler.profiler();
        try (Profiler.ProfiledInterval ignored = profiler.profile();){
            this.expensiveComputation(profiler);
        }
        profiler.finish();
        String output = ProfilerTest.getProfilerOutput(profiler);
        Assertions.assertThat((String)output).contains(new CharSequence[]{METHOD});
    }

    @Test
    void profilerMustLimitItselfToProfiledRegion() throws Exception {
        Profiler profiler = Profiler.profiler();
        try (Profiler.ProfiledInterval ignored = profiler.profile();){
            this.expensiveComputation(profiler);
        }
        ProfilerTest.otherIntenseWork();
        profiler.finish();
        String output = ProfilerTest.getProfilerOutput(profiler);
        Assertions.assertThat((String)output).contains(new CharSequence[]{METHOD});
        Assertions.assertThat((String)output).doesNotContain(new CharSequence[]{"otherIntensiveWork"});
    }

    private static String getProfilerOutput(Profiler profiler) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try (PrintStream out = new PrintStream(buffer);){
            profiler.printProfile(out, "Profile");
            out.flush();
        }
        return buffer.toString();
    }

    private void expensiveComputation(Profiler profiler) throws InterruptedException {
        do {
            Thread.sleep(10L);
        } while (!ProfilerTest.getProfilerOutput(profiler).contains(METHOD));
    }

    private static void otherIntenseWork() throws InterruptedException {
        Thread.sleep(10L);
    }
}

