/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.scheduler.CancelListener;

public interface JobHandle<T> {
    public static final JobHandle<?> EMPTY = new NullJobHandle();

    public void cancel();

    public void waitTermination() throws InterruptedException, ExecutionException;

    public void waitTermination(long var1, TimeUnit var3) throws InterruptedException, ExecutionException, TimeoutException;

    public T get() throws ExecutionException, InterruptedException;

    default public void registerCancelListener(CancelListener listener) {
        throw new UnsupportedOperationException("Unsupported in this implementation");
    }

    public static class NullJobHandle<T>
    implements JobHandle<T> {
        @Override
        public void cancel() {
        }

        @Override
        public void waitTermination() {
        }

        @Override
        public void waitTermination(long timeout, TimeUnit unit) {
        }

        @Override
        public T get() {
            return null;
        }
    }
}

