/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.Listeners;
import org.neo4j.internal.helpers.NamedThreadFactory;

class ListenersTest {
    ListenersTest() {
    }

    @Test
    void addNull() {
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> new Listeners().add(null));
    }

    @Test
    void add() {
        Listener[] listenersArray = new Listener[]{new Listener(), new Listener(), new Listener()};
        Listeners<Listener> listeners = ListenersTest.newListeners(listenersArray);
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(listenersArray), ListenersTest.asList(listeners));
    }

    @Test
    void removeNull() {
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> new Listeners().remove(null));
    }

    @Test
    void remove() {
        Listener listener1 = new Listener();
        Listener listener2 = new Listener();
        Listener listener3 = new Listener();
        Listeners<Listener> listeners = ListenersTest.newListeners(listener1, listener2, listener3);
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(listener1, listener2, listener3), ListenersTest.asList(listeners));
        listeners.remove((Object)listener1);
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(listener2, listener3), ListenersTest.asList(listeners));
        listeners.remove((Object)listener3);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(listener2), ListenersTest.asList(listeners));
    }

    @Test
    void notifyWithNullNotification() {
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> new Listeners().notify(null));
    }

    @Test
    void notifyWithNotification() {
        String message = "foo";
        Listener listener1 = new Listener();
        Listener listener2 = new Listener();
        Listeners<Listener> listeners = ListenersTest.newListeners(listener1, listener2);
        listeners.notify(listener -> listener.process(message));
        org.junit.jupiter.api.Assertions.assertEquals((Object)message, (Object)listener1.message);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Thread.currentThread().getName(), (Object)listener1.threadName);
        org.junit.jupiter.api.Assertions.assertEquals((Object)message, (Object)listener2.message);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Thread.currentThread().getName(), (Object)listener2.threadName);
    }

    @Test
    void notifyWithNullExecutorAndNullNotification() {
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> new Listeners().notify(null, null));
    }

    @Test
    void notifyWithNullExecutorAndNotification() {
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> new Listeners().notify(null, listener -> listener.process("foo")));
    }

    @Test
    void notifyWithExecutorAndNullNotification() {
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> new Listeners().notify((Executor)Executors.newSingleThreadExecutor(), null));
    }

    @Test
    void notifyWithExecutorAndNotification() throws Exception {
        String message = "foo";
        String threadNamePrefix = "test-thread";
        Listener listener1 = new Listener();
        Listener listener2 = new Listener();
        Listeners<Listener> listeners = ListenersTest.newListeners(listener1, listener2);
        ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.named((String)threadNamePrefix));
        listeners.notify((Executor)executor, listener -> listener.process(message));
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.MINUTES);
        org.junit.jupiter.api.Assertions.assertEquals((Object)message, (Object)listener1.message);
        Assertions.assertThat((String)listener1.threadName).startsWith((CharSequence)threadNamePrefix);
        org.junit.jupiter.api.Assertions.assertEquals((Object)message, (Object)listener2.message);
        Assertions.assertThat((String)listener2.threadName).startsWith((CharSequence)threadNamePrefix);
    }

    @Test
    void listenersIterable() {
        Listener listener1 = new Listener();
        Listener listener2 = new Listener();
        Listener listener3 = new Listener();
        Listeners<Listener> listeners = ListenersTest.newListeners(listener1, listener2, listener3);
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList(listener1, listener2, listener3), ListenersTest.asList(listeners));
    }

    private static <T> List<T> asList(Listeners<T> listeners) {
        ArrayList list = new ArrayList();
        for (Object listener : listeners) {
            list.add(listener);
        }
        return list;
    }

    @SafeVarargs
    private static <T> Listeners<T> newListeners(T ... listeners) {
        Listeners result = new Listeners();
        for (T listener : listeners) {
            result.add(listener);
        }
        return result;
    }

    private static class Listener {
        volatile String message;
        volatile String threadName;

        private Listener() {
        }

        void process(String message) {
            this.message = message;
            this.threadName = Thread.currentThread().getName();
        }
    }
}

